#ifndef USSENSOR_INCLUDED
#define USSENSOR_INCLUDED

/**
 * Klasse zur Verwendung des Ultraschallsensors
 */

class USSensor {
 public:
  /**
   * Konstruktion mit übergabe der Pin-Nummern.
   * @param trigPin Nummer des Arduino-Triggerpins (TRIG auf dem Sensor)
   * @param echoPin Nummer des Arduino-Echopins (ECHO auf dem Sensor)
   */
  USSensor(int trigPin, int echoPin);


  /**
   * Führt eine Messung aus. Liefert die Distanz in cm oder 0 als float (fehlerhalfte Messung oder Distanz > 1m)
   * @return Distanz in cm oder 0 (fehlerhalfte Messung oder Distanz > 1m)
   */
  float measure();

 private:
  int trigPin;
  int echoPin;
};


#endif
