#include "robot.h"
#include "Arduino.h"

Robot::Robot() :
  motors(), lcd(0x27), buttons(22,23,24,25), menu(lcd, buttons)
{};

void Robot::begin() {
  Wire.begin();
  lcd.begin(16, 2);
  lcd.setBacklight(1);
  lcd.home(); lcd.clear();
  lcd.print("Ivobot 1.0");
  lcd.setCursor(0,1);
  lcd.print("Vbat=");
  lcd.print(vBat());
  lcd.print(" V");
  delay(1000);
  lcd.home(); lcd.clear();
  motors.begin();
}

Robot robot;

float Robot::vBat() {
  return analogRead(VBAT_PIN)*10.0/1023;
}

