#ifndef MENU_INCLUDED
#define MENU_INCLUDED

/**
 * Klasse, um einfache Menüs zu realiseren.
 */

#include <LiquidCrystal_PCF8574.h>
#include "buttons.h"

class Menu {
 public:
  /**
   * Wird intern von der Robot Klasse aufgerufen.
   */
  Menu(LiquidCrystal_PCF8574& _lcd, Buttons& buttons);

  /**
   * Zeigt die 4 Strings an und liefert die Auswahl (1 bis 4) zurück.
   *
   * @param msg1 String für 1. Auswahl
   * @param msg2 String für 2. Auswahl
   * @param msg3 String für 3. Auswahl
   * @param msg4 String für 4. Auswahl
   *
   * @return Getroffene Auswahl (1-4).
   */
  int choice(char *msg1, char *msg2, char *msg3, char *msg4);

  /**
   * Erlaubt es einem, eine float-Zahl auf dem Display anzupassen. Mit
   * 1 und 2 wird der Wert verändert, mit 3 wird abgebrochen, mit 4 wird bestätigt.
   * @param title Titel für die erste Zeile
   * @param start Startwert
   * @param dt Schrittweite für die Veränderung
   * @return Ausgewählter Wert oder ursprünglicher Wert wenn mit Button 3 abgebrochen wurde
   */
  float adjustFloat(char *title, float start, float dt);

  

 private:
  LiquidCrystal_PCF8574* lcd;
  Buttons* buttons;
};


//extern Robot robot;

#endif
