#include "menu.h"

Menu::Menu(LiquidCrystal_PCF8574& _lcd, Buttons& _buttons)
{
  lcd = &_lcd;
  buttons = &_buttons;
}

int Menu::choice(char *msg1, char *msg2, char *msg3, char *msg4) {
  lcd->clear();
  lcd->setCursor(0,0);
  lcd->print(msg1);
  lcd->setCursor(8,0);
  lcd->print(msg2);
  lcd->setCursor(0,1);
  lcd->print(msg3);
  lcd->setCursor(8,1);
  lcd->print(msg4);
  int but = buttons->waitForPress();
  if (but==4) return 3;
  if (but==8) return 4;
  return but;
}

float Menu::adjustFloat(char *title, float start, float diff) {
  float neu = start;
  float mul = 1+diff/(start==0 ? diff : start);
  lcd->clear();
  lcd->setCursor(0,0);
  lcd->print(title);
  lcd->setCursor(0,1);
  lcd->print(neu);
  while (true) {
    int but = buttons->waitForPressRepeated();
    if (but==8) return neu;
    if (but==4) return start;
    if (but==1 | but ==2) {
      if (but==1) {
      	neu -= diff;
            } else {
      	neu += diff;
      }
      lcd->setCursor(0,1);
      lcd->print(neu);
      lcd->print("    ");
    }
  }
  buttons->waitClear();
}
