#ifndef IRSENSOR_INCLUDED
#define IRSENSOR_INCLUDED

/**
 * Klasse zur Benutzung eines IR-Sensors
 */

class IRSensor {
 public:
  /**
   * Initialisierung.
   * @param ledPin Arduinopinnummer für die IR-Led (digitalerPin)
   * @param outPin Arduinopinnummer für den Output (analogerPin A0-A15)
   */
  IRSensor(int ledPin, int outPin);

  /// LED anschalten.
  void on();

  /// LED ausschalten
  void off();

  /// Output auslesen (einfaches analogRead)
  int read();

  /**
   * Komplette Messung. Differenz zwischen Intensität mit und ohne LED wird geliefert (>=0). Die LED ist nach der Messung immer ausgeschaltet.
   * @return Differenz zwischen ein und aus. Mindestens 0.
   */
  // complete measure:
  // difference between led on and off
  int measure();

 private:
  int ledPin;
  int outPin;
};


#endif
