#include "irsensor.h"
#include <Arduino.h>

IRSensor::IRSensor(int _led, int _out) {
  ledPin = _led;
  outPin = _out;
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, LOW);
  pinMode(outPin, INPUT);
  digitalWrite(outPin, LOW);
}

void IRSensor::on() {
  digitalWrite(ledPin, HIGH);
}

void IRSensor::off() {
  digitalWrite(ledPin, LOW);
}

int IRSensor::read() {
  return analogRead(outPin);
}

int IRSensor::measure() {
  int hv = 0;
  int lv = 0;
  if (digitalRead(ledPin)==HIGH) {
    hv = analogRead(outPin);
    digitalWrite(ledPin, LOW);
    delayMicroseconds(50);
    lv = analogRead(outPin);
  } else {
    lv = analogRead(outPin);
    digitalWrite(ledPin, HIGH);
    delayMicroseconds(50);
    hv = analogRead(outPin);
    digitalWrite(ledPin, LOW);
  }
  hv = hv-lv;
  if (hv<0) hv=0;
  return hv;
}
