#ifndef BUTTONS_INCLUDED
#define BUTTONS_INCLUDED

/**
 * Klasse um die kapazitiven Touchbuttons anzusprechen.
 */

class Buttons {
 public:
  /**
   * Dieser Konstruktor wird im Konstruktor Robot::Robot aufgerufen. Dort sind auch die Pins der Buttons 1 bis 4 festgelegt.
   * @param p1 Arduinopinnummer für Button 1
   * @param p2 Arduinopinnummer für Button 2
   * @param p3 Arduinopinnummer für Button 3
   * @param p4 Arduinopinnummer für Button 4
   */
  Buttons(int p1, int p2, int p3, int p4);

  /**
   * Zugriff via \code robot.buttons.get(); \endcode
   * Aktueller Zustand der Butttons als Bitmaske (bzw. Summe der Werte: Button 1 -> 1, Button 2 -> 2, Button 3 -> 4, Button 4 -> 8)
   * @return Bitmaske der gedrückten Buttons.
   */
  int get();
  
  /**
   * Wartet, bis ein Button gedrückt wurde und liefert die Bitmaske (nicht die Buttonnummer!) zurück.
   * Die Methode wartet, bis kein Button mehr gedrückt wurde.
   * die Methode 
   * @return Bitmaske des gedrückten Knopfs.
   */
  int waitForPress();

  /**
   * Liefert die Bitmaske eines gedrückten Buttons zurück, erlaubt aber das Repetieren wenn der Button gedrückt gehalten wird.
   * Das erste Mal dauert es 0.4s, danach wird jede 0.1s der Button zurückgeliefert. Die Methode muss dazu natürlich immer wieder
   * aufgerufen werden.
   *
   * Die Methode wird in Menu::adjustFloat verwendet.
   *
   * @return Bitmaske des gedrückten Buttons.
   */
  int waitForPressRepeated();

  /**
   * Wartet, bis kein Button mehr gedrückt ist.
   */
  void waitClear();
  
 private:
  int pins[4];
  long lastus;
  int lastpress;

};


#endif
