#include "ussensor.h"
#include <Arduino.h>

USSensor::USSensor(int trig, int echo) {
  trigPin = trig;
  echoPin = echo;
  pinMode(trig, OUTPUT);
  pinMode(echo,INPUT);
}

float USSensor::measure() {
  digitalWrite(trigPin,HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  long d = pulseIn(echoPin,HIGH,6000);
  // Distanz in cm
  return d/2.0/29.1;
}
