#ifndef ROBOT_INCLUDED
#define ROBOT_INCLUDED

#include <Wire.h>
#include <LiquidCrystal_PCF8574.h>
#include "motors.h"
#include "buttons.h"
#include "menu.h"
#include <Arduino.h>

#define VBAT_PIN A0

/**
 * Roboterklasse. Wird automatisch instanziert und ist als globale Variable robot verfügbar.
 * 
 * Die Arduino-Pins sind wie folgt festgelegt:
 *   - Pin 2 und 3: Lichtschrankenoutput links und rechts.
 *   - Pins 5,6,7,8 Motorensteuerung: 5,6 links: vorwärts, rückwärts. 7,8 rechts: vorwärts, rückwärts.
 *   - Pins 22,23,24,25 Buttons 1,2,3,4
 *   - LCD auf SDA/SCL
 */

class Robot {

 public:
  /** Motorensteuerung. Wird automatisch initialisiert via robot.begin() */
  Motors motors;

  /** LCD Display. Wird automatisch initialisiert im Konstuktor und robot.begin() */
  LiquidCrystal_PCF8574 lcd;

  /** Buttons. Wird automatisch initialisiert im Konstruktor. Arduinopins sind in robot.cpp definiert. */
  Buttons buttons;

  /** Helper für Menus. Wird automatisch initialisert im Konstruktor.*/
  Menu menu;
  
  Robot();

  /** Muss beim Programmstart einmal aufgerufen werden. */
  void begin();

  /** Liefert die Batteriespannung in V zurück 
   * @return Batteriespannung in V als float
   */
  float vBat();
  
};

/**
 * Globale Variable
 */

extern Robot robot;

#endif
