/**
 * Wichtig: Erst muss die Library LiquidCrystal_PCF8574 (by Matthias Herte) installiert werden:
 * Sketch -> Include Libraries -> Manage Libraries -> Search LiquidCrystal_PCF8574
 */


#include "robot.h"
#include "irsensor.h"
#include "ussensor.h"
#include <Servo.h>

// IR-Sensor auf Pin 26 (LED) und A15 (OUT)
// IRSensor ist der Typ (Art) der Variable, die Variable selbst heisst 'ir' (beliebiger Name)
IRSensor ir(26,A15);

// US-Sensor mit Trigger auf Pin 40, Echo auf pin 41
// Variablenname 'us' (beliebig), USSensor ist der Typ (vorgegeben, Definition siehe Datei ussensor.h)
USSensor us(40,41);

// Signal für Servo auf pin 53
#define SERVOPIN 53
// Mittelposition in Grad, muss angepasst werden.
#define SERVO_MITTE 90
// Servo Objekt (Variablenname 'servo', Gross-/Kleinschreibung ist relevant!)
Servo servo;


/**
 * setup wird ausgeführt, wenn der Arduino eingeschaltet, bzw. resettet wird.
 * 
 * Initialisierungen finden hier statt.
 */
void setup() {
  // Für debugging über den Serial-Monitor (Ctrl+Shift+M). Geschwindigkeit auf 115200 einstellen.
  Serial.begin(115200);
  Serial.println("Hello");

  // Servo einschalten auf Mittelposition fahren (Wert kann oben angepasst werden).
  servo.attach(SERVOPIN);
  servo.write(SERVO_MITTE);
  // Roboter initialisieren (Motoren, Buttons, LCD), dauert 1000 ms
  robot.begin();

  // Servo wieder ausschalten.
  servo.detach();
}

// Ultraschall-Sensor testen
void test_us() {
  while (robot.buttons.get()==0) { // Solange kein Button gedrück ist, wiederholen
    float d = us.measure();  // Resultat ist Kommazahl (float) in cm
    robot.lcd.clear();       // LCD löschen
    robot.lcd.print(d);      // Wert ausgeben
    delay(100);              // 0.1s warten
  } // ende der while-Schleife
  robot.buttons.waitClear();  // Warten, bis kein Button mehr gedrückt ist.
}

// Infrarot-Sensor testen
void test_ir() {
  while (robot.buttons.get()==0) { // Solange kein Button gedrück ist
    int w = ir.measure();   // Resultat ist Ganzzahl (int), Wert zwischen 0 (kein Objekt) bis max 1023 (wohl eher 900) nahes, helles Objekt
    robot.lcd.clear();
    robot.lcd.print(w);     // Ausgabe
    delay(100);
  } // ende der while-Schleife
  robot.buttons.waitClear();  // Warten, bis kein Button mehr gedrückt ist.
}

// Servo testen
void test_servo() {
  servo.attach(SERVOPIN);
  robot.lcd.clear();
  for (int winkel=SERVO_MITTE; winkel<170; winkel++) {
    robot.lcd.setCursor(0,0);
    robot.lcd.print(winkel);
    servo.write(winkel); // Winkel setzten
    delay(10); // Etwas Zeit, um die Position auch anzufahren
    if (robot.buttons.get()!=0) { // Button gedrückt (nicht Null)?
      break; // Wiederholung abbrechen
    }
  }
  for (int winkel=170; winkel>=SERVO_MITTE; winkel--) {
    robot.lcd.setCursor(0,0);
    robot.lcd.print(winkel);
    robot.lcd.print(" ");
    servo.write(winkel); // Winkel setzten
    delay(10); // Etwas Zeit, um die Position auch anzufahren    
    if (robot.buttons.get()!=0) { // Button gedrückt (nicht Null)?
      break; // Wiederholung abbrechen
    }
  }
  servo.detach();
  robot.buttons.waitClear(); // Warten, bis kein Button mehr gedrückt ist (falls abgebrochen wurde)
}


// Hilfsprogramm für test_motors()
void zeige_ticks_und_spannung() {
  robot.lcd.setCursor(0,1);  // 1. Zeichen (0), 2. Zeile (1)
  robot.lcd.print(robot.motors.getTicks(0));   // Ticks ausgeben
  // Batteriespannung ausgeben
  robot.lcd.print("  VBat=");
  robot.lcd.print(robot.vBat());
  robot.lcd.print("V  ");
}

// Motor(en) testen
void test_motors() {
  robot.lcd.clear();
  robot.lcd.print("M. links  vor");
  robot.motors.setPowers(700,0);  // Linker Motor aus Power 700 (von 799), rechter Motor stop (Power 0).
  robot.motors.resetCounters();   // Tick-Zähler auf 0 setzen
  while (robot.motors.getTicks(0)<20) { // So lange keine volle Umdrehung
    zeige_ticks_und_spannung(); // Unterprogramm aufrufen  
    delay(10);
    if (robot.buttons.get()!=0) { // Button gedrückt (nicht Null)?
      break; // Wiederholung abbrechen
    }    
  }
  
  robot.motors.setPowers(0,0);  // beide Motoren stop
  while (micros()-robot.motors.getLastTicks(0)<500000L) { // Warten bis 0.5s kein Tick mehr (das ist L ist nötig um den Typ auf long festzulegen, sonst ist es ein in (max 32000))
    zeige_ticks_und_spannung(); // Unterprogramm aufrufen  
    delay(10);
  }
  robot.buttons.waitClear();
}


// Wird immer wieder aufgerufen
void loop() {
  // Menu anzeigen, Resultat ist Ganzzahl (int), gespeichert in der Variablen 'choice'
  int choice = robot.menu.choice("[1] US", "[2] IR", "3 Servo", "4 Motors");
  if (choice==1) { // Wenn gleich 1
       test_us();    // Unterprogramm test_us aufrufen (siehe oben)
  } else if (choice==2) { // Sonst wenn gleich 2
    test_ir();
  } else if (choice==3)  {
    test_servo();
  } else if (choice==4)  {
    test_motors();
  }
}

