#include "buttons.h"
#include "Arduino.h"

Buttons::Buttons(int p1, int p2, int p3, int p4) {
  pins[0] = p1;
  pins[1] = p2;
  pins[2] = p3;
  pins[3] = p4;
  lastus = 0;
  lastpress = 0;
  
}

int Buttons::get() {
  return digitalRead(pins[0]) |
    (digitalRead(pins[1]) << 1) |
    (digitalRead(pins[2]) << 2) |
    (digitalRead(pins[3]) << 3);
}

int Buttons::waitForPress() {
  int but;
  while (true) {
    but = get();
    if (but==1 || but==2 || but==4 || but==8) break;
  }
  while(get()!=0);
  return but;
}
int Buttons::waitForPressRepeated() {
  int but;
  while (true) {
    but = get();
    if (but==1 || but==2 || but==4 || but==8) break;
  }
  if (lastpress==but && (micros()-lastus)<100000) {
    while(micros()-lastus<100000);
    lastus = micros();
    return but;    
  } else {
    lastpress=but;
    lastus = micros();
  }
  while(get()==but && (micros()-lastus)<400000);
  if (get()==but) {
    lastpress = but;
    lastus=micros();
  } else {
    lastpress = 0;
  }
  return but;
}



void Buttons::waitClear() {
  while (get()!=0);
}


