
# Wir wollen ein Zahlenratespiel programmieren.
# Das Programm wählt zufällig eine Zahl zwischen 1 und 100 aus. Versuchen sie
# den Code, der das macht zu verstehen!
# Der Spieler / die Spielerin kann dann wiederholt eine Zahl eingeben. Der Code, um die
# Eingaben des Spielers zu überprüfen fehlt aber noch. Machen sie folgendes:

# Wichtig: Das Programm beendet im Ausgangszustand nicht. Sie können auf der
# Konsole ein laufendes Programm mit <Strg>+<C> beenden.

# 1. Bauen sie innerhalb der Schleife ein, dass wenn der Spieler oder die Spielerin die richtige
# Zahl eingibt, die Variable gefunden angepasst wird so dass die Schleife nicht
# mehr wiederholt. Fügen sie zudem eine Ausgabe ein, um den Spieler / die Spielerin zu
# informieren, dass er / sie gewonnen hat.

# 2. Das Spiel ist immer noch ziemlich schwierig. Um dem Spieler / der Spielerin zu helfen,
# wollen wir ihr / ihm helfen, indem wir angeben ob die geratene Zahl grösser
# oder kleiner als die geheime Zahl war. Bauen sie dies ein, indem sie im Fall
# dass die geratene Zahl nicht korrekt war die Zahl mit der richtigen Zahl
# vergleichen und je nach dem ausgeben, ob sie grösser oder kleiner ist.

# 3. Jetzt sollte das Spiel schon gut spielbar sein. Zum Schluss wollen wir noch
# einbauen, dass wir die Anzahl Versuche zählen, die der Spieler / die Spielerin
# bereits gebraucht hat. Überlegen sie sich, wie sie das am besten einbauen.
# Passen sie schlussendlich noch die Bedingung der while-Schleife an, so dass
# nicht mehr unlimitiert Versuche zur Verfügung stehen.


# Import der Funktion `randrange` aus der Bibliothek `random`
from random import randrange

maximum = 100
geheim = randrange(1, maximum+1) # Zufällige Zahl zwischen 1 und `maximum`

max_versuche = 6
gefunden = False
versuche = 0

# Diese Schleife wiederholt sich, so lange `gefunden` False ist
while not gefunden and versuche < max_versuche:
    geraten = int(input(f"Erraten sie die Zahl zwischen 1 und {maximum}: "))
    versuche += 1

    # Hier etwas mit der geratenen Zahl anfangen
    if geraten == geheim:
        print("Glückwunsch, sie haben die Zahl entdeckt! Sie war: ", geheim)
        gefunden = True
    elif geraten > geheim:
        print("Die Zahl ist kleiner als ihre Vermutung")
    else:
        print("Die Zahl ist grösser als ihre Vermutung")

if not gefunden:
    print("Sie haben alle Versuche aufgebraucht und die Zahl leider nicht gefunden :(")

