from pyscript import window, document
from js import myGlobal
from asyncio import sleep

from laby import Laby
from pnmbild import PNMBild
from wegaufbild import wegAufBild
from wegerweiterung import wegerweiterung
from wegkomplettieren import wegKomplettieren
from svgexport import svgExport
from parameter import Parameter

async def showAscii(laby):
    document.getElementById("output").innerHTML = "<pre>"+str(laby)+"</pre>\n"
    await sleep(0.01)

Laby.showAscii = showAscii

async def makeLaby(evt):
    document.getElementById("pystart").style.display="none"
    el = document.getElementById("output")

    param = Parameter()
    param.svg = None

    laby = Laby(myGlobal.width, myGlobal.height)
    await showAscii(laby)
    p = 0
    for y in range(laby.hoehe):
        for x in range(laby.breite):
            laby[x,y].bild = myGlobal.data[p]
            p+=1
    
    await showAscii(laby)
    laby.clearMarks()
    weg = wegAufBild(laby)
    await showAscii(laby)
    await wegerweiterung(weg)
    await showAscii(laby)
    await wegKomplettieren(laby, weg)
    svg = svgExport(laby, param)
    el.innerHTML = svg


print(myGlobal.key)
document.getElementById("pystart").addEventListener("click", makeLaby)
