from zelle import Zelle
from laby import Laby
from random import shuffle, randrange


async def wegKomplettieren(laby:Laby, weg:list[Zelle]) -> None:
    todo = [zelle for zelle in weg]   # Kopie vom Weg (damit dieser nicht verändert wird)
    shuffle(todo)                     # Verwürfeln
    dirs = [0,1,2,3]
    i=0
    while len(todo)>0:
        i+=1
        if i%laby.breite==0:
            await laby.showAscii()
        if randrange(25)==0:
            shuffle(todo)
            todo.sort(key=lambda x:x.mark, reverse=True)
        aktuell = todo.pop()  # Letztes Element entfernen
        shuffle(dirs)
        for dir in dirs:
            nb = aktuell.nachbar(dir)
            if nb!=None and nb.mark==" ":
                aktuell.zustand(dir, True)  # Wand öffnen
                nb.mark=['O', '.'][nb.bild]            # Nachbar markieren
                todo.append(aktuell)   # Da könnte es ja noch in andere Richtungen weiter gehen
                todo.append(nb)        # Den Nachbar als nächstes bearbeiten
                break                  # For-Schleife verlassen


