from zelle import Zelle
from laby import Laby
from startzielpaar import startzielpaar
from random import shuffle

def labyrinthNurMitWeg(laby:Laby, weg:list[Zelle]) -> None:
    # Alle Markierungen löschen
    laby.clearMarks()
    # Alle Wände schliessen
    laby.closeAll()
    # Weg-Zellen mit # markieren
    for zelle in weg:
        zelle.mark = "#"
    # Wände auf dem weg öffnen
    for i in range(len(weg)-1):      # Vom ersten bis vorletztem Weg-Element
        d = weg[i].dirTo(weg[i+1])   # Richtung des Wegs an Stelle i
        weg[i].zustand(d, True)      # Wand in diese Richtung öffnen

def randWandAuf(zelle:Zelle) -> None:
    if zelle.y==0:
        zelle.zustand(3, True)
    elif zelle.y==zelle.laby.hoehe-1:
        zelle.zustand(1, True)
    elif zelle.x==0:
        zelle.zustand(2, True)
    elif zelle.x==zelle.laby.breite-1:
        zelle.zustand(0, True)

def raenderOeffnen(paar: list[Zelle]) -> None:
    randWandAuf(paar[0])
    randWandAuf(paar[1])
    paar[0].mark="S"
    paar[1].mark="Z"



def wegAufBild(laby:Laby) -> list[Zelle]:
    """
    Generiert eine Liste mit Zellen eines Weges, der nur schwarze Pixel benutzt
    und zwei möglichst weit voneinander entfernte Randzellen verbindet.
    """
    paar = startzielpaar(laby)
    dirs = [0,1,2,3]
    todo = [paar[0]]     # todo-Liste, start beim ersten Element vom Paar
    paar[0].mark = "S"   # Startzelle markieren
    while len(todo)>0:   # So lange, wie es noch Elemente in der Todo-Liste hat
        aktuell = todo.pop()  # Letztes Element entfernen
        shuffle(dirs)
        for dir in dirs:
            nb = aktuell.nachbar(dir)
            if nb!=None and nb.mark==" " and nb.bild==0:
                aktuell.zustand(dir, True)  # Wand öffnen
                retourDir = (dir+2) % 4     # 180 Grad drehen, von 4,5 auf 0,1 korrigieren (module)
                nb.mark=str(retourDir)      # Nachbar markieren
                todo.append(aktuell)   # Da könnte es ja noch in andere Richtungen weiter gehen
                todo.append(nb)        # Den Nachbar als nächstes bearbeiten
                break                  # For-Schleife verlassen
    #print(laby)
    aktuell = paar[1]     # Zielzelle
    weg = [aktuell]    # Weg besteht erst mal nur aus der Zielzelle
    while aktuell!=paar[0]:   # Solange man nicht bei der Startzelle angekommen ist
        wohin = int(aktuell.mark)   # Richtung, in der es zurück geht.
        aktuell = aktuell.nachbar(wohin)  # Nachbarzelle
        weg.append(aktuell)

    #print(laby)
    labyrinthNurMitWeg(laby, weg)
    raenderOeffnen(paar)
    return weg