
class Parameter:
    def __init__(self):
        # Default Parameter
        self.pnm:str = "herz.pnm"
        self.svg:str = "herz.svg"
        self.breite:int = 210
        self.hoehe:int = 297
        self.rand:int = 20
        # Parameter von der Kommandozeile lesen
        # self.parse()
        # Zur Kontrolle ausgeben (ruft die Methode __str__ auf)
        print(self)


    def hilfe(self):
        print("Folgende Kommandozeilenargumente werden unterstützt:\n")
        print("-b breite      Breite vom SVG in mm.")
        print("-h hoehe       Höhe vom SVG in mm.")
        print("-r rand        Rand vom SVG in mm.")
        print("datei.pnm      Eingabe-Datei im pnm (P3) Format.")
        print("datei.svg      Ausgabe-Datei im svg Format.")
        # Programm beenden
        exit()

    def parse(self) -> None:
        # Zahl nach gegebenem Kommandozeilen Argument zurückgeben (oder Fehler melden)
        def getArg(needle):
            try:
                i = argv.index(needle)
                if i+1>=len(argv):
                    print(f"Nach {needle} wird eine natürliche Zahl erwartet.\n\n")
                    self.hilfe()
                a = argv[i+1]
                if not a.isnumeric():
                    print(f"Nach {needle} wird eine natürliche Zahl erwartet.\n\n")
                    self.hilfe()
                return int(a)
            except ValueError:  # Kein solches Argument übergeben.
                return None
            
        def getFileWithExt(ext):  # Dateinamen mit gegebener Endung finden
            candidates = [f for f in argv if f.endswith(ext)]
            if len(candidates)>0:
                return candidates[0]
            return None
        
        # Argumente auslesen und gegebenfalls speichern
        b = getArg("-b")
        if b:
            self.breite = b
        h = getArg("-h")
        if h:
            self.hoehe = h
        r = getArg("-r")
        if r:
            self.rand = r

        pnm = getFileWithExt(".pnm")
        if pnm:
            self.pnm = pnm
        svg = getFileWithExt(".svg")
        if svg:
            self.svg = svg

    def __str__(self):
        res  = f"Input:    {self.pnm}\n"
        res += f"Output:   {self.svg}\n"
        res += f"Breite:   {self.breite} mm\n"
        res += f"Höehe:    {self.hoehe} mm\n"
        res += f"Rand:     {self.rand} mm"
        return res