window.addEventListener('load', ()=>{
    document.getElementById("upload").addEventListener("change", async (evt)=>{
        var tgt = evt.target, files = tgt.files;
        if (FileReader && files && files.length) {
            await processFile(files[0]);
        }
    });

    
        async function processFile(file) {
            return new Promise((resolve, reject)=>{
                var fr = new FileReader();
                fr.onload = async function() {
                    await image2img(fr);
                    resolve();
                }
                fr.onerror = reject;
                fr.readAsDataURL(file);
            });
        }
    
        async function image2img(fileReader) {
            return new Promise((resolve, reject)=> {
                var img = document.createElement("img");
                img.onload = ()=>{
                    getImageData(img).then(()=>{
                        resolve();
                    });
                };
                img.onerror = reject;
                img.src = fileReader.result;
            });
        }
    
        async function getImageData(img) {
            var canvas = document.createElement("canvas");
            var ctx = canvas.getContext("2d");
            var imageData;
            canvas.width = img.width;
            canvas.height = img.height;
            ctx.drawImage(img, 0, 0);
            imageData = ctx.getImageData(0, 0, img.width, img.height);
            myGlobal.width = img.width;
            myGlobal.height = img.height;
            myGlobal.data = [];
            let p = 0;
            for (let y=0; y<img.height; y++) {
                for (let x=0; x<img.width; x++) {
                    s = imageData.data[p]+imageData.data[p+1]+imageData.data[p+2];
                    p+=4;
                    myGlobal.data.push(s>3*128 ? 1 : 0);
                }
            }
            document.getElementById('pystart').style.display="inline";
        }
});