from zelle import Zelle
from laby import Laby
from random import randrange


def einmalErweiterung(weg : list[Zelle]) -> bool:
    """
    Durchsucht alle Wegelement auf eine erweiterbare Konfiguration und
    für die Erweiterung durch und gibt dann True zurück.

    Wird keine solche Konfiguration gefunden, wird False zurückgegeben.

    die Wegelemente a,b wären eine solche Konfiguration. 
    +---+---+---+---+---+   +
    |   |   |   |   | d   # |
    +---+---+---+---+   +---+
    |   | a   b |   | c |   |
    +---+   +   +---+   +---+

    Danach sieht der Weg wie folgt aus:
    +---+---+---+---+---+   +
    |   | x   y |   | d   # |
    +---+   +   +---+   +---+
    |   | a | b |   | c |   |
    +---+   +   +---+   +---+
    """
    start = randrange(len(weg)-1)       # Zufälliger Startindex vom Wegelement
    for i in range(len(weg)-1):         
        ii = (i+start)%(len(weg)-1)     # Index vom ersten Element der Konfiguration
        a = weg[ii]        # Zelle a
        b = weg[ii+1]      # Zelle b
        dir = a.dirTo(b)   # Richtung von a zu b
        for rechtwinklig in [(dir+1)%4, (dir+3)%4]:   # Beide rechtwinkligen Richtungen testen
            x = a.nachbar(rechtwinklig)      # Nachbarn x und y bestimmen
            y = b.nachbar(rechtwinklig)
            # Falls diese existieren, und schwarz sind, und noch nicht markiert
            if x!=None and y!=None and x.bild==0 and y.bild==0 and x.mark==" " and y.mark==" ":
                a.zustand(dir, False)            # von a zu b schliessen
                a.zustand(rechtwinklig, True)    # von a zu x öffnen
                x.zustand(dir, True)             # von x zu y öffnen
                b.zustand(rechtwinklig, True)    # von b zu y öffnen
                x.mark = "#"                     # x und y markieren
                y.mark = "#"
                weg.insert(ii+1, x)              # und in der Wegliste einsetzen
                weg.insert(ii+2, y)
                # Funktion beenden und Erfolg melden.
                return True
    return False



def wegerweiterung(weg: list[Zelle]) -> bool:
    """
    So lange eine Erweiterung möglich ist, wiederholen.
    """
    aenderung = False
    while einmalErweiterung(weg):
        aenderung = True
    return aenderung
