from laby import Laby
from zelle import Zelle
from parameter import Parameter


def svgExport(laby:Laby, parameter:Parameter) -> None:

    # Breite, Höhe und Rand in mm (A4 Hochformat)
    breite = parameter.breite
    hoehe = parameter.hoehe
    rand = parameter.rand

    unit = min([(breite-2*rand)/laby.breite, (hoehe-2*rand)/laby.hoehe])   # mm pro Zelle, für die Skalierung
    offsets = [(breite-laby.breite*unit)/2, (hoehe-laby.hoehe*unit)/2]   # Verschiebung für symmetrische Ränder

    svg = f'<?xml version="1.0" encoding="UTF-8"?>\n<svg id="ssa" width="{breite}mm" height="{hoehe}mm"\n      version="1.1" viewBox="0 0 {breite} {hoehe}"\n      xmlns="http://www.w3.org/2000/svg" viewport-fill="white">\n'
    style = f'style="fill:none;stroke:#000000;stroke-opacity:1;stroke-linecap:round;stroke-width:{0.7/unit:.4f}"'
    svg += f"  <g id='laby' transform='translate({offsets[0]:.2f} {offsets[1]:.2f}) scale({unit:.2f})'\n       {style}>\n"

    for spalte in laby.zellen:
        for zelle in spalte:
            if not zelle.offen[3]: # oben auf jeden Fall zeichnen
                svg += f"    <path d='M {zelle.x} {zelle.y} h 1'/>'\n"
            if not zelle.offen[2]: # links auf jeden Fall zeichnen
                svg += f"    <path d='M {zelle.x} {zelle.y} v 1'/>'\n"
            if zelle.x==laby.breite-1 and not zelle.offen[0]:  # nach rechts nur in der letzten Spalte
                svg += f"    <path d='M {zelle.x+1} {zelle.y} v 1'/>'\n"
            if zelle.y==laby.hoehe-1 and not zelle.offen[1]:  # nach unten nur in der letzten Zeile
                svg += f"    <path d='M {zelle.x} {zelle.y+1} h 1'/>'\n"
    svg += "  </g>\n</svg>\n"

    with open(parameter.svg,"w") as svgFile:
            svgFile.write(svg)
            