#!/usr/bin/env pybricks-micropython
"""
Karlheinz Schubert
Template EV3
https://pybricks.com/ev3-micropython/ev3devices.html
https://pybricks.com/ev3-micropython/robotics.html
"""
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import (
    Motor,
    TouchSensor,
    ColorSensor,
    InfraredSensor,
    UltrasonicSensor,
    GyroSensor,
)
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile

# Brick Definition
ev3 = EV3Brick()
ev3.speaker.beep()

# Fahrwerksdefinition und -integration
Motor_links = Motor(Port.A)
Motor_rechts = Motor(Port.B)
Fahrwerk = DriveBase(
    Motor_links, Motor_rechts, 55, 125
)  # Motor links, Motor rechts, Raddurchmesser (in mm), Radabstand (in mm)
Fahrwerk.settings(
    200, 200, 45, 100
)  # Geradeaus-Geschwindigkeit, Geradeaus-Beschleunigung, Drehgeschwindigkeit, Drehbeschleunigung

# Gabel-Motor
Heber = Motor(Port.C)

# Sensordefinition und -integration
HellSensor = ColorSensor(Port.S1)  # Bitte Anschluss überprüfen.
FarbSensor = ColorSensor(Port.S4)  # Bitte Anschluss überprüfen.
DistanceSensor = UltrasonicSensor(Port.S2)  # Bitte Anschluss überprüfen

print("Setup ok")
green_sensor_flag = True
# Funktionsdefinitionen
def folge_Linie_bis_Hindernis():
    global green_sensor_flag
    Zaehler = 0
    Distance = 100
    while Distance > 90:
        Zaehler += 1
        Distance = DistanceSensor.distance()
        Helligkeit = HellSensor.reflection()
        Farbe = FarbSensor.color()
        if green_sensor_flag and Farbe in [Color.GREEN, Color.BLUE] :
            green_sensor_flag = False
            break
        print(
            "{}: Abstand: {:5d}, Helligkeit: {:5d}, Farbe: {}".format(
                Zaehler, Distance, Helligkeit, Farbe)
            )
        
        if Helligkeit < 16:
            Fahrwerk.drive(30, -10)
        elif Helligkeit > 25:
            Fahrwerk.drive(30, 10)
        else:
            Fahrwerk.drive(50, 0)
        wait(5)
    Fahrwerk.stop()


def hole_Material():
    Heber.run_angle(100, 50)
    Fahrwerk.straight(800)
    Heber.run_angle(-50, 50)
    Fahrwerk.straight(-800)
    Fahrwerk.turn(180)
    folge_Linie_bis_Hindernis()

def bewege_dich_zum_gruenen_Pfad():
    Fahrwerk.straight(50)
    Fahrwerk.turn(90)

# Programmstart
folge_Linie_bis_Hindernis()
bewege_dich_zum_gruenen_Pfad()
folge_Linie_bis_Hindernis()
hole_Material()

# Endsignal und Sicherheitstop
ev3.speaker.beep()
ev3.speaker.beep()
Fahrwerk.stop()
