#!/usr/bin/env pybricks-micropython
"""
Karlheinz Schubert
Template EV3
"""
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import Motor, TouchSensor, ColorSensor, InfraredSensor, UltrasonicSensor, GyroSensor
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile

# Brick Definition
ev3 = EV3Brick()
ev3.speaker.beep()

sensor = ColorSensor(Port.S3)


# Programmstart
zaehler = 0
while True:
    # Read the color and reflection
    color = sensor.color()
    reflection = sensor.reflection()
    print('{:4d}: Helligkeit: {:3d}, Farbe: {}'.format(zaehler, reflection, color))
    zaehler += 1
    wait(50)
