#!/usr/bin/env pybricks-micropython
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import (Motor, TouchSensor, ColorSensor,
                                 InfraredSensor, UltrasonicSensor, GyroSensor)
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile


# This program requires LEGO EV3 MicroPython v2.0 or higher.
# Click "Open user guide" on the EV3 extension tab for more information.


# Create your objects here.
ev3 = EV3Brick()


# Write your program here.
ev3.speaker.beep()


links = Motor(Port.A)
rechts = Motor(Port.B)
licht = ColorSensor(Port.S3)  # Bitte Anschluss überprüfen.

fahrwerk = DriveBase(links, rechts, 55, 125)
fahrwerk.drive(20,0)


while True:
   hell = licht.reflection()
   # fahrwerk.drive(Geschwindigkeit vorwärts in mm/s, Drehgeschwindigkeit in Grad/s)
   if hell<40:  # Wert anpassen
      fahrwerk.drive(100,50)
   elif hell>60:  # Wert anpassen!
      fahrwerk.drive(100,-50)
   else:
      fahrwerk.drive(100,0)
 
fahrwerk.stop()
fahrwerk.straight(-30)
