#!/usr/bin/env pybricks-micropython
# This program requires LEGO EV3 MicroPython v2.0 or higher.
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import (
    Motor,
    TouchSensor,
    ColorSensor,
    InfraredSensor,
    UltrasonicSensor,
    GyroSensor,
)
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile

from math import pi  # Wert pi importieren

# Initialisierungen
raddurchmesser = 55  # Phantasiewert! Bitte ersetzen
korrektur = 0
radumfang = (raddurchmesser + korrektur) * pi  # Hier Formel mit pi einsetzen
grad_pro_mm = 360 / radumfang  # Phantasiewert, bitte anpassen, am besten direkt aus dem Radumfang berechnen.
mm_pro_grad = 1.0 / grad_pro_mm
print("d={:5.2f}, u={:5.2f}, °/mm={:5.2f}, mm/°={:5.2f}".format(raddurchmesser, radumfang, grad_pro_mm, mm_pro_grad))


# Create objects.
ev3 = EV3Brick()
ev3.speaker.beep()
# Connect all 3 motors
links = Motor(Port.A)
rechts = Motor(Port.B)
heber = Motor(Port.C)

distanz = 1000  # 100 cm soll der Roboter fahren

links.run_angle(220, distanz * grad_pro_mm, wait=False)  # 120 Grad/s Drehgeschwindigkeit, Drehwinkel, nicht warten, sondern gleich den nächsten Befehl.
rechts.run_angle(220, distanz * grad_pro_mm, wait=True)  # Dito, aber warten, bis fertig gedreht.

links.stop()
rechts.stop()

ev3.speaker.beep()
ev3.speaker.beep()
