#!/usr/bin/env pybricks-micropython
"""
Karlheinz Schubert
Template EV3
https://pybricks.com/ev3-micropython/ev3devices.html
https://pybricks.com/ev3-micropython/robotics.html
"""
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import (
    Motor,
    TouchSensor,
    ColorSensor,
    InfraredSensor,
    UltrasonicSensor,
    GyroSensor,
)
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile

# Brick Definition
ev3 = EV3Brick()
ev3.speaker.beep()

# Fahrwerksdefinition und -integration
links = Motor(Port.A)
rechts = Motor(Port.B)
fahrwerk = DriveBase(
    links, rechts, 55, 125
)  # Motor links, Motor rechts, Raddurchmesser (in mm), Radabstand (in mm)
fahrwerk.settings(
    200, 200, 45, 100
)  # Geradeaus-Geschwindigkeit, Geradeaus-Beschleunigung, Drehgeschwindigkeit, Drehbeschleunigung

# Gabel-Motor
heber = Motor(Port.C)

# Sensordefinition und -integration
licht = ColorSensor(Port.S3)  # Bitte Anschluss überprüfen.
ultraschall = UltrasonicSensor(Port.S2)  # Bitte Anschluss überprüfen

print("Setup ok")

# Funktionsdefinitionen
def folge_Linie_bis_Hindernis():
    zaehler = 0
    distance = 100
    while distance > 90:
        zaehler += 1
        distance = ultraschall.distance()
        hell = licht.reflection()
        color = licht.color()
        print(
            "{}: Abstand: {:5d}, Helligkeit: {:5d}, Farbe: {}".format(
                zaehler, distance, hell, color
            )
        )
        if hell < 20:
            fahrwerk.drive(30, -10)
        elif hell > 25:
            fahrwerk.drive(30, 10)
        else:
            fahrwerk.drive(50, 0)
        wait(5)
    fahrwerk.stop()


def hole_Material():
    heber.run_angle(100, 50)
    fahrwerk.straight(800)
    heber.run_angle(-50, 50)
    fahrwerk.straight(-800)
    fahrwerk.turn(180)
    fahrwerk.straight(-50, 300)


# Programmstart
folge_Linie_bis_Hindernis()
hole_Material()

# Endsignal und Sicherheitstop
ev3.speaker.beep()
ev3.speaker.beep()
fahrwerk.stop()
