#!/usr/bin/env pybricks-micropython
"""
Karlheinz Schubert
Template EV3
"""
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import Motor, TouchSensor, ColorSensor, InfraredSensor, UltrasonicSensor, GyroSensor
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile

# Brick Definition
ev3 = EV3Brick()
ev3.speaker.beep()

# Fahrwerksdefinition und -integration
links = Motor(Port.A)
rechts = Motor(Port.B)
heber = Motor(Port.C)
fahrwerk = DriveBase(links, rechts, 55, 125)  # Motor links, Motor rechts, Raddurchmesser (in mm), Radabstand (in mm)
fahrwerk.settings(200, 200, 45, 100)  # Geradeaus-Geschwindigkeit, Geradeaus-Beschleunigung, Drehgeschwindigkeit, Drehbeschleunigung

# Sensordefinition und -integration
licht = ColorSensor(Port.S3)  # Bitte Anschluss überprüfen.
ultraschall = UltrasonicSensor(Port.S2)  # Bitte Anschluss überprüfen

print('Setup ok')
# Funktionsdefinitionen


# Programmstart
# Programmstart
zaehler = 0
while True:
    distance = ultraschall.distance()
    print('{}: Abstand: {}'.format(zaehler, distance))
    zaehler += 1
    wait(50)

# Sicherheitstop
ev3.speaker.beep()
ev3.speaker.beep()
fahrwerk.stop()