import os
import sys
import glob
import time
import sys

# Sowohl key, wie auch text sind ASCII-Codiert
def verschleiern(*, key, text):
    res = ""
    for i in range(len(text)):
        c = ord(text[i])
        if (c>=32):
            k = ord(key[i % (len(key))])
            c = c ^ (k & 31)
        res += chr(c)
    return res

def say(key, text):
    text = verschleiern(key=key,text=text)
    if "-f" in sys.argv:
        sys.stdout.write(text)
        sys.stdout.flush()
    else:
        for l in text:
            sys.stdout.write(l)
            time.sleep(0.03)
            if (l in " "):
                time.sleep(0.1)
            if (l in ",."):
                time.sleep(0.3)
            if (l in "\n"):
                time.sleep(0.6)
            sys.stdout.flush()

def fileExists(key, path):
    path = verschleiern(key=key, text=path)
    #print(f"Checking for {path}")
    return os.path.exists(path)

def getglob(key, path):
    path = verschleiern(key=key, text=path)
    #print(f"Checking for glob {path} -> len={len(glob.glob(path))}")
    return glob.glob(path)

def existsOrNot(*, path, yes, no):
    if os.path.exists(path):
        return yes
    return no

def createFile(*, key, path, contents, answer=None):
    path = verschleiern(key=key, text=path)
    contents = verschleiern(key=key, text=contents)
    if "{answer}" in contents:
        contents = contents.replace("{answer}", answer)
    with open(path, "w") as f:
        f.write(contents)
    

def contentsOrNot(*,key, path, no, decrypt=False):
    path = verschleiern(key=key, text=path)
    no = verschleiern(key=key, text=no)
    if os.path.exists(path):
        # print(f"Reading path={path}")
        with open(path, "r") as f:
            contents = f.read()
            print(f"read contents={contents}")
            if decrypt:
                contents=verschleiern(key=key, text=contents)
                print(f"Encrypted content ->{contents}")
            return contents
    return no


def startswith(*,key,start,text):
    start = verschleiern(key=key, text=start)
    return text.startswith(start)