from simrobot import *
from random import randrange


# Zufaellige Startposition und Startwinkel festlegen
RobotContext.setStartPosition(50+randrange(100), 250+randrange(100))
RobotContext.setStartDirection(45+randrange(45))
# Hintergrund (fuer Lichtsensor) laden.
RobotContext.useBackground("challenge.png")

# Mauern fuer Ultraschall-Distanzsensor definieren. 
#   Koordinaten der Aussenpunkte bezüglich dem Mittelpunkt, Mittelpunkt.
RobotContext.useTarget("empty.png", ((-150,30),(150,30)),250,20)
RobotContext.useTarget("empty.png", ((-30,-150),(-30,150)), 480,350)

# Roboter initialisieren
robot = LegoRobot()

# Raeder hinzufuegen
gear = Gear()
robot.addPart(gear)

# Lichtsensor hinzufuegen und starten
ls = LightSensor(SensorPort.S3)
robot.addPart(ls)
ls.activate(True)

# Ultraschallsensor hinzufuegen
us = UltrasonicSensor(SensorPort.S1)
robot.addPart(us)

# Die grafische Anzeige des Ultraschalls ist zwar schoen und nett, stoert aber manchmal den Lichtsensor
#us.setBeamAreaColor(makeColor("green"))  
#us.setProximityCircleColor(makeColor("lightgray"))



###########################################
## B E G I N   D E S   P R O G R A M M S ##
###########################################


# Motoren einschalten
gear.forward()

# Unendlich wiederholen
while (True):
    l = ls.getValue()               # Aktueller Helligkeitswert
    print("Helligkeit = %d" % l)    # Ausgeben
    if (l<300):                     # Wenn dunkler als 300, Schleife beenden
        break
    Tools.delay(100)                # 1/10 Sekunde warten

# Motoren halt
gear.stop()

# Ein bisschen drehen
gear.left(400)

# Aktuelle Distanz messen
d = us.getDistance()
print("Bin jetzt %d Einheiten von der Mauer entfernt" % d)





