#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    import uio
    from globals import __np
    import time
    
    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
        
    program = "import time\nfrom machine import Pin\nfrom globals import __np\nIVO_L1 = 1\nIVO_L2 = 2\nIVO_L3 = 4\nIVO_R1 = 8\nIVO_R2 = 16\nIVO_R3 = 32\n# L1     R1\n#\n# L2  L3   R3  R2\nclass Ivobuttons:\n def __init__(self):\n  self.pins = [Pin(p, Pin.IN, Pin.PULL_UP if p==0 else Pin.PULL_DOWN) for p in (0, 32, 33, 14, 13, 27)]\n  self.wait = [0 for p in range(6)]\n  self.first = [True for p in range(6)]\n  self.delay = 400\n  self.repeat_delay=0\n def states(self):\n  res=0\n  for i in range(6):\n   ms = time.ticks_ms()\n   if self.pins[i].value()==(0 if i==0 else 1):\n    if self.wait[i]<ms:\n     if self.first[i]:\n      self.wait[i] = ms+self.delay\n      self.first[i] = False\n     else:\n      self.wait[i] = ms+self.repeat_delay\n     res+=1<<i\n   else:\n    self.first[i] = True\n    self.wait[i] = 0\n  return res\nivobuttons = Ivobuttons()\ndef fastDot(x,y,c):\n __np._np[x+y*8]=c\ndef fastGetDot(x,y):\n return __np._np[x+y*y]\ndef fastRepaint():\n __np._np.write()\ndef getms():\n return time.ticks_ms()\n"
    with uio.open('ivobuttons.py', 'wb') as f:
                f.write(program)
    print("File written!")
    from oxocard import *
    display("OK", GREEN)
except ImportError:
    pass