#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    from globals import __np
    import time

    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
except ImportError:
    pass
###################################
# Start vom eigentlichen Programm #
###################################


# Aufgaben:
# 
# - Studieren und verstehen Sie das Programm.
#     Wie sind die Koordinaten der Punkte in der Variablen 'punkte' gespeichert?
#     Was enthaelt die Variable 'p' in    for p in punkte:
#
# - Programmieren Sie, dass die Steine nicht ineinander fahren koennen.
#   - Loeschen Sie dazu erst den Stein (ohne fastRepaint())
#   - Ueberpruefen Sie dann, ob alle neuen Koordinaten auch schwarz sind.
# - Programmieren Sie weitere Steine, die zufaellig ausgewaehlt werden.
#
#

from oxocard import *
from ivobuttons import *


# Variablen, die den Zustand des Spiels beschreiben
# Koordinaten der Punkte und Farbe der Punkte
punkte = [[3,1],[4,1],[4,0]]
farbe = RED
# Zeitpunkt, zu dem der Punkt nach unten rutscht
fallZeit = 0
fallWarten = 1000 # 1000 Millisekunden warten, bis der Punkt nach unten rutscht


# Funktionen, die den Spielzustand aendern und
# die Grafik aktualisieren

# Stein zeichnen
def zeichnen():
    global punkte,farbe
    for p in punkte:
        fastDot(p[0], p[1], farbe)

# Stein loeschen
def loeschen():
    global punkte, farbe
    for p in punkte:
        fastDot(p[0],p[1], BLACK)
        

def verschieben(dir):
    # Zugriff auf Zustandsvariablen
    global punkte,farbe
    # Falls moeglich, den Punkt um 'dir' in x-Richtung verschieben und neu zeichnen
    ok = True  # Annahme: Verschieben ist moeglich
    for p in punkte:
        if (p[0]+dir<0 or p[0]+dir>7): # Ein Teil verlaesst das Spielfeld
            ok = False
    if ok: # Wirklich moeglich
        loeschen()
        for p in punkte:
            p[0]+=dir
        zeichnen()
        fastRepaint()
        

def fallen():
    # Zugriff aus Zustandsvariablen
    global punkte, farbe, fallZeit, fallWarten
    if fallZeit < getms(): # Ist es schon Zeit?
        ok = True
        for p in punkte:
            if (p[1]+1>7):
                ok = False
        if ok:
            loeschen()
            for p in punkte:
                p[1]+=1
            zeichnen()
            fastRepaint()
            fallZeit = getms()+fallWarten     # Naechster Zeitpunkt
        else: # Der Punkt ist schon unten, neuen Punkt generieren
            punkte = [[3,0],[4,0],[4,1]]
            farbe = (randint(60,255), randint(60,255), randint(60,255))  # Zufallsfarbe
            zeichnen()
            fastRepaint()
            fallZeit = getms()+fallWarten   # Naechster Zeitpunkt


clear(BLACK)
zeichnen()
fastRepaint()

ivobuttons.repeat_delay=50  # Damit das Spiel spielbar bleibt...

while True:
    states = ivobuttons.states()
    if (states & IVO_R2):
        verschieben(1)
    if (states & IVO_R3):
        verschieben(-1)
    fallen()