#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    from globals import __np
    import time
    
    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
except ImportError:
    pass
###################################
# Start vom eigentlichen Programm #
###################################


# Aufgaben:
# 
# - Fuehren Sie einmal die Datei upload_ivobuttons.py *auf der OxoCard* aus.
# - Oeffnen Sie die Datei ivobuttons.py vom Ordner turbo1 ebenfalls in TigerJython.
# - Studieren Sie die Datei ivobuttons.py, um einen Ueberblick ueber die
#     Nummerierung der Knoepfe und die implementierten Funktionen zu erhalten.
# - Testen Sie dieses Programm im Simulator.
# - Testen Sie dieses Programm auf der OxoCard.
# - Studieren und verstehen Sie dieses Programm. Stellen Sie Fragen wenn noetig.
#
# - Programmieren Sie die beiden Knoepfe ganz links hinzu, und steuern Sie damit die y-Koordinate
# - Progrmamieren Sie dann den Knopf rechts oben hinzu, um die Farbe zu aendern.
#
# 
# 



from oxocard import *
from ivobuttons import *

# Variablen, die den Zustand beschreiben
x = 3
y = 3
farbe = BLUE


# Funktion, die die x-Koordinate um "dir" verschiebt und neu zeichnet.    
def move(dir):
    global x,y,farbe
    if (x+dir>=0 and x+dir<8):
        fastDot(x,y,BLACK)
        x+=dir
        fastDot(x,y,farbe)
        fastRepaint()


# Ausgangslage
clear(BLACK)
# Nichts verschieben, aber zeichnen
move(0)

# Game-Loop, Endlos wiederholen
while True:
    # Zustand der Knoepfe abfragen
    states = ivobuttons.states()
    # ist R2 gedrueck?
    if (states & IVO_R2):
        move(1)
    # ist R3 gedrueckt?
    if (states & IVO_R3):
        move(-1)
    

    