# -*- coding: utf-8 -*-
# Das ist die dummy-Version fuer TigerJython, laeuft so nicht auf der OxoCard
# Dafuer ist die Datei upload_ivobuttons.py auf die OxoCard zu laden.
#
# Folgende Funktionen und Konstanten sind hier definiert:
#
# ivobuttons.states()
#     liefert den Zustand aller 6 Knoepfe.
#     Wir ein Knopf gedrueckt ist das Bit 1, 
#     bleibt er gedrueckt ist danach das Bit fuer 400ms 0,
#     danach 1, so lange er gedrueckt beleibt.
# 
# IVO_L1                           IVO_R1
# 
# IVO_L2  IVO_L3           IVO_R3  IVO_R2
#
# Code Beispiel:
#      s = ivobuttons.states()
#      if (s & IVO_R3):
#          # Tu was, wenn R3 gedrueckt ist
#
#
#  ivobuttons.delay = 200 (setzt die wartezeit vor der Reptition auf 200ms)
#  ivobuttons.repeat_delay = 100 (setzt die Pause zwischen den Widerholungne auf 100ms)
#
#
#
#
# fastDot(x,y,c)
#     wie dot(x,y,c), wobei c ein Trippel sein muss.
#     Achtung: Es findet keine Ueberpruefung der
#     sinnhaftigkeit der Parameter statt!
#
# fastGetDot(x,y)
#     wie getColor(x,y), liefert die Farbe als Trippel
#
# 
# fastRepaint()
#     wie repaint()
#
# getms()
#     liefert eine Anzahl Milisekunden (seit irgendeinem festen Zeitpunkt)
#




import time
from oxocard import _sim, _buttonClickCallbacks, dot, repaint

class Button():
    def __init__(self, buttonLabel, buttonClicked = None):
        self._buttonLabel = buttonLabel
        btnIndex = _sim.labelToIndex(buttonLabel)
        _buttonClickCallbacks[btnIndex] = buttonClicked
        
    def wasPressed(self):
        time.sleep(0.001)  # in case of narrow loops
        return _sim.wasButtonPressed(self._buttonLabel)
    
    def isPressed(self):
        time.sleep(0.001)  # in case of narrow loops
        return _sim.isButtonPressed(self._buttonLabel)


IVO_L1 = 1
IVO_L2 = 2
IVO_L3 = 4
IVO_R1 = 8
IVO_R2 = 16
IVO_R3 = 32

# L1                 R1
#
# L2  L3         R3  R2

class Ivobuttons:
    def __init__(self):
        self.buttons = [Button(b) for b in ("BUTTON_L1", "BUTTON_L2", "BUTTON_L3", "BUTTON_R1", "BUTTON_R2", "BUTTON_R3")]
        self.wait = [0 for p in self.buttons]
        self.first = [True for p in self.buttons]
        self.delay = 400
        self.repeat_delay = 0
        
    def states(self):
        res = 0
        for i in range(6):
            if self.buttons[i].isPressed():
                if self.wait[i]<time.time():
                    if self.first[i]:
                        self.wait[i] = time.time()+self.delay/1000
                        self.first[i] = False
                    else:
                        self.wait[i] = time.time()+self.repeat_delay/1000
                    res+=1<<i
            else:
                self.first[i] = True
                self.wait[i] = 0
        return res

        
ivobuttons = Ivobuttons()

def fastDot(x,y,c):
    dot(x,y,c)
    
def fastGetDot(x,y):
    return getColor(x,y)

def fastRepaint():
    repaint()
    
def getms():
    return int(time.time()*1000)

