#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    from globals import __np
    import time

    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
except ImportError:
    pass
###################################
# Start vom eigentlichen Programm #
###################################


# Aufgaben:
# 
# - Studieren und verstehen Sie das Programm.
#     Was genau ist den Variablen 'fallZeit' und 'fallWarten' gespeichert?
#     Wo werden die benutzt, warum und wie?
#
# - Vervollstaendigen Sie die Funktion 'verschieben' unten,
#     so dass der Punkt nach links und rechts verschoben werden kann.
#
# - Mit 'getColor(x,y)' erhaelt man die Farbe des Punktes an der
#     entsprechenden Koordinate. Erweitern Sie das Programm so,
#     - dass der Punkt auf bereits vorhandenen Punkten liegen bleibt, und
#     - dass der Punkt nicht durch bereits vorhandene Punkte hindurch
#         verschoben werden kann.


from oxocard import *
from oxobutton import *


# Variablen, die den Zustand des Spiels beschreiben
# Koordinaten und Farbe vom Punkt
x = 4
y = 0
farbe = RED
# Zeitpunkt, zu dem der Punkt nach unten rutscht
fallZeit = 0
fallWarten = 1 # 1 Sekunde warten, bis der Punkt nach unten rutscht


# Funktionen, die den Spielzustand aendern und
# die Grafik aktualisieren

def verschieben(dir):
    # Zugriff auf Zustandsvariablen
    global x,y,farbe
    # Falls moeglich, den Punkt um 'dir' in x-Richtung verschieben und neu zeichnen
    
    # TODO: HIER FEHLT IHR CODE

def fallen():
    # Zugriff aus Zustandsvariablen
    global x,y, farbe, fallZeit, fallWarten
    if fallZeit < time.time(): # Ist es schon Zeit?
        if y<7:  # Kann der Punkt noch weiter fallen?
            dot(x,y,BLACK)  # Aktuellen Punkt loeschen
            y+=1            # Nach unten schieben
            fallZeit = time.time()+fallWarten     # Naechster Zeitpunkt
            dot(x,y,farbe)  # Punkt zeichnen
        else: # Der Punkt ist schon unten, neuen Punkt generieren
            x = randint(0,7)
            y = 0
            farbe = (randint(20,255), randint(20,255), randint(20,255))  # Zufallsfarbe
            dot(x,y,farbe)
            fallZeit = time.time()+fallWarte   # Naechster Zeitpunkt
        repaint()


enableRepaint(False)

TasteRechts = Button( BUTTON_R2 )  # Taste rechts unten
TasteLinks = Button( BUTTON_R3 )  # Linke Test rechts


while True:
    if TasteLinks.isPressed():
        verschieben(-1)
    if TasteRechts.isPressed():
        verschieben(1)
    fallen()