#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    from globals import __np
    import time

    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
except ImportError:
    pass
###################################
# Start vom eigentlichen Programm #
###################################


# Aufgaben:
# 
# - Studieren und verstehen Sie das Programm.
# - Programmieren Sie den Knopf R5 so, dass die Variable 'alteFarbe' auf eine andere Farbe
#   als schwarz gesetzt wird.
#


from oxocard import *
from oxobutton import *

TasteLinks = Button( BUTTON_R2 )  # Taste rechts unten
TasteRechts = Button( BUTTON_R3 )  # Linke Test rechts

TasteOben = Button( BUTTON_L1 )  # Taste links oben
TasteUnten = Button( BUTTON_L2 )  # Taste kinks unten

# Zustand vom Spiel
x=4
y=4
alteFarbe = BLACK

# Funktion zum Verschieben der x-Koordinate und neu zeichnen
def verschieben(dx,dy):
    # Zugriff auf die Variablen x,y,alteFarbe:
    global x,y,alteFarbe
    # Nur wenn die Verschiebung auch moeglich ist
    if (x+dx>=0 and x+dx<8 and y+dy>=0 and y+dy<8):
        dot(x,y,alteFarbe)
        x = x+dx
        y = y+dy
        alteFarbe = getColor(x,y)
        dot(x,y,BLUE)
        repaint()


enableRepaint(False)

# Game zeichnen
verschieben(0,0)

# Game loop (unendlich wiederholen)
while True:
    if TasteLinks.isPressed():
        verschieben(1,0)
    if TasteRechts.isPressed():
        verschieben(-1,0)
    if TasteOben.isPressed():
        verschieben(0,-1)
    if TasteUnten.isPressed():
        verschieben(0,1)
        
        


