#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    from globals import __np
    import time

    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
except ImportError:
    pass
###################################
# Start vom eigentlichen Programm #
###################################


# Aufgaben:
# 
# - Studieren und verstehen Sie das Programm.
# - Ersetzen Sie isPressed() durch wasPressed(). Was stellen Sie fest?
# - Benutzen Sie wieder isPressed()
# - Fügen Sie zusätzlich eine y-Koordinate ein und zwei weitere Knöpfe, um diese manipulieren.
#


from oxocard import *
from oxobutton import *

TasteRU = Button( BUTTON_R2 )  # Taste rechts unten
TasteLU = Button( BUTTON_L2 )  # Taste Links unten

# Zustand vom Spiel
x=4

# Funktion zum Verschieben der x-Koordinate und neu zeichnen
def verschieben(wohin):
    # Zugriff auf die Variable x:
    global x
    # Nur wenn die Verschiebung auch moeglich ist
    if (x+wohin>=0 and x+wohin<8):
        dot(x,4,BLACK)
        x = x+wohin
        dot(x,4,BLUE)
        repaint()


enableRepaint(False)

# Game zeichnen
verschieben(0)

# Game loop (unendlich wiederholen)
while True:
    if TasteRU.isPressed():
        verschieben(1)
    if TasteLU.isPressed():
        verschieben(-1)
        
        


