#Initialisierung der Oxocard
try:
    from machine import Pin, deepsleep, ADC, reset
    from globals import __np
    import time

    Pin(2, Pin.OUT).value(1) # audio ampli on
    Pin(15, Pin.OUT).value(0) # neopix on
    __np.set(37, 0xffff00, update = True)
    # Möglichkeit zum Ausschalten...
    for i in range(50):
        if Pin(13, Pin.IN, Pin.PULL_DOWN).value() == 1 and Pin(27, Pin.IN, Pin.PULL_DOWN).value() == 1:
            print("Power off")
            for k in [250, 100, 50, 20, 10, 5, 1, 0]:
                for i in range(8):
                    __np.set(9*i+1, k << 16, update = False)
                    __np.set(7*i+8, k << 16, update = False)
                __np.show()
                time.sleep(0.5)
            Pin(2, Pin.OUT).value(0) # audio ampli off
            Pin(15, Pin.OUT).value(1) # neopix off    
            deepsleep()
        time.sleep(0.02)
except ImportError:
    pass
###################################
# Start vom eigentlichen Programm #
###################################


# Aufgabe:
# Fuegen Sie einen zweiten Knopf hinzu, der etwas anderes anzeigt.
#
# Mehr dazu auf https://fginfo.ksbg.ch/dokuwiki/lib/exe/fetch.php?media=lehrkraefte:blc:informatik:glf19:oxocard:oxocard.pdf
# 


from oxocard import *
from oxobutton import *

TasteRU = Button( BUTTON_R2 )  # Taste rechts unten
TasteRL = Button( BUTTON_R3 )  # Taste rechts unten links


while True:
    if TasteRU.isPressed():
        display("RU", GREEN)
    elif TasteRL.isPressed():
        display("RL", RED)
    else:
        clear(BLUE)
        


