// Erst mal alles Laden, erst dann an der Webseite
// Dinge ändern (die sonst noch gar nicht existieren würden)
window.addEventListener('load', function() {
    // 4 CSS Klassen wert0 bis wert3 definieren.
    Raster.addColorRules(["white","red","green", "blue","#aa0","magenta", "cyan", "purple"]);

    // Raster anlegen
    let raster = [new Raster(10,20, "gridcontainerleft"), new Raster(10,20, "gridcontainerright")];
    // Tetris Objekts
    let tetris = raster.map((r)=>new Tetris(r, gameOver, multipleLines));


    function gameOver(game) {
        let player = tetris.indexOf(game);
        console.log(`Player ${player} häts väbäset!`);
    }
    function multipleLines(game, anzahl) {
        let player = tetris.indexOf(game);
        console.log(`Player ${player} hat ${anzahl} Linien!`);
        tetris[1-player].addLines([0,0,1,2,4][anzahl]);
    }


/*
 _____         _        _              
|_   _|_ _ ___| |_ __ _| |_ _   _ _ __ 
  | |/ _` / __| __/ _` | __| | | | '__|
  | | (_| \__ \ || (_| | |_| |_| | |   
  |_|\__,_|___/\__\__,_|\__|\__,_|_|   
*/
    
    let timeoutHandler = {};

    document.body.addEventListener('keydown', (ev)=>{
        let firstTime = 200;
        let secondTime = 40;

        let keysAndActions = {"ArrowLeft":{board:1,dx:-1,dy:0},
                          "ArrowRight":{board:1,dx:1,dy:0},
                          "ArrowUp":{board:1,dx:0,dy:0},
                          "ArrowDown":{board:1,dx:0,dy:1},
                          "KeyA":{board:0,dx:-1,dy:0},
                          "KeyD":{board:0,dx:1,dy:0},
                          "KeyW":{board:0,dx:0,dy:0},
                          "KeyS":{board:0,dx:0,dy:1},
        }
        let key = ev.code;
        if (!keysAndActions[key]) {
            return;
        }

        let action;
        let a = keysAndActions[key];
        if (a.dx==0 && a.dy==0) {                
            action = ()=>tetris[a.board].rotate(1);
        } else {
            action = ()=>tetris[a.board].translate(a.dx, a.dy);
        }
        let repeatedAction = ()=>{
            if (timeoutHandler[key]) {
                this.clearTimeout(timeoutHandler[key]);
            }
            if (action()) {
                timeoutHandler[key] = setTimeout(repeatedAction, secondTime);
            }
        }
        action();
        if (timeoutHandler[key]) {
            this.clearTimeout(timeoutHandler[key]);
        }
        timeoutHandler[key] = setTimeout(repeatedAction, firstTime);
    });    
    document.body.addEventListener('keyup', (ev)=>{
        let key = ev.code;
        if (timeoutHandler[key]) {
            clearTimeout(timeoutHandler[key]);
            timeoutHandler[key]=undefined;
        }
    });

/*
 _____                _     
|_   _|__  _   _  ___| |__  
  | |/ _ \| | | |/ __| '_ \ 
  | | (_) | |_| | (__| | | |
  |_|\___/ \__,_|\___|_| |_|
*/
    function getRelativeCoordinates(touch) {
        let x = touch.clientX/window.innerWidth;
        let y = touch.clientY/window.innerHeight;
        return {x,y};
    }

    this.document.body.addEventListener('touchstart', (ev)=>{
        let {x,y} = getRelativeCoordinates(ev.changedTouches[0]);
        if (x<0.4) {
            tetris.translate(-1,0);
        } else if (x>0.6) {
            tetris.translate(1,0);
        } else if (y>0.8) {
            tetris.translate(0,1);
        } else {
            tetris.rotate();
        }

    });

});

