class Tetris {
    constructor(raster, gameOverCallback, multipleLinesCallback) {
        this.raster = raster;
        this.timestep = 1000;
        this.gameOverCallback = gameOverCallback;
        this.multipleLinesCallback = multipleLinesCallback;
        // Zufällig Position der Lücke für eingeschobene Linien
        this.gapPosition = Math.floor(Math.random()*raster.width);
        this.newBlock();
    }

    addLines(anzahl) {
        // Zeilen hochkopieren
        for (let y=0; y<this.raster.height-anzahl; y++) {
            for (let x=0; x<this.raster.width; x++) {
                this.raster.setValue(x,y, this.raster.getValue(x,y+anzahl));
            }
        }
        // Zeilen unten mit Muster und Lücke füllen
        let color = Math.floor(Math.random()*7);
        for (let y=this.raster.height-anzahl; y<this.raster.height; y++) {
            for (let x=0; x<this.raster.width; x++) {
                let c = (y+color)%7 + 1;
                if (x==this.gapPosition) c = 0;
                this.raster.setValue(x,y,c);
            }
        }
        // Aktuellen Block nach oben schieben
        this.posY-=anzahl;
    }

    newBlock() {
        this.posX=4;
        this.posY=0;
        this.blockNumber = Math.floor(Math.random()*7)+1;
        this.currentBlock = [
            [[0,0],[0,1],[0,2],[0,3]],
            [[0,0],[1,0],[0,1],[1,1]],
            [[0,0],[0,1],[0,2],[1,0]],
            [[0,0],[1,0],[1,1],[1,2]],
            [[0,0],[1,0],[2,0],[1,1]],
            [[0,0],[1,0],[1,1],[2,1]],
            [[0,1],[1,1],[1,0],[2,0]]
        ][this.blockNumber-1];
        let maxy = Math.max(...(this.currentBlock.map((pt)=>pt[1])));
        for (let i=0; i<4; i++) {
            this.currentBlock[i][1]-=maxy;
        }
        // TODO überprüfen, ob Feld schon voll, oder
        // dieser Block tatsächlich platziert werden kann.
        // Sonst Game Over.
        if (!this.ok(this.currentBlock, this.posX, this.posY, false)) {
            console.log("Game over");
            this.gameOverCallback(this);
        } else {
            this.timeoutHandler = setTimeout(
                ()=>this.translate(0,1), 
                this.timestep);
        }   
        this.draw();
    }

    draw(color=undefined) {
        color = color===undefined ? this.blockNumber : color;
        for (let pos of this.currentBlock) {
            let x = pos[0]+this.posX;
            let y = pos[1]+this.posY;
            if (this.raster.isOn(x,y)) {
                this.raster.setValue(x,y,color);
            }
        }
    }

    erase() {
        this.draw(0);
    }

    // Returns true, if the block can be
    // positioned on the field
    ok(block, x, y, eraseAndRedraw=true) {        
        x = x!==undefined ? x : this.posX;
        y = y!==undefined ? y : this.posY;
        // Test
        if (eraseAndRedraw) this.erase();
        for (let i=0; i<4; i++) {
            let a = x+block[i][0];
            let b = y+block[i][1];
            if (b>=0) {
                if (!this.raster.isOn(a,b)) {
                    this.draw();
                    return false;
                }
                if (this.raster.getValue(a,b)!=0) {
                    this.draw();
                    return false;
                }
            }
        }
        if (eraseAndRedraw) this.draw();
        return true;
    }

    // returns a new array of rotated positions, 
    // flush in the first quadrant
    rotatedBlock(dir=1) {
        // TODO, gedrehte Koordinaten in neues Array berechnen.
        let block = [];
        let minx = 0;
        let maxy = 0;
        for (let i=0; i<4; i++) {
            let a = this.currentBlock[i][0];
            let b = this.currentBlock[i][1];
            let x = -b*dir;
            let y = a*dir;
            if (x<minx) minx = x;
            if (y>maxy) maxy = y;
            block.push([x,y]);
        } 
        for (let i=0; i<4; i++) { // in ersten Quadranten schieben
            block[i][0] -= minx;
            block[i][1] -= maxy;
        }
        return block;
    }

    // Returns true, if the rotation was made
    rotate(dir=1) {
        let block = this.rotatedBlock();
        if (this.ok(block)) {
            this.erase();
            this.currentBlock = block;
            this.draw();
            return true;
        }
        return false;
    }

    // Returns true, if the translation was made
    translate(dx,dy) {
        if (dy==1) { // Verschiebung nach unten
            clearTimeout(this.timeoutHandler);
        }
        if (this.ok(this.currentBlock, this.posX+dx, this.posY+dy)) {
            this.erase();
            this.posX+=dx;
            this.posY+=dy;
            this.draw();
            if (dy==1) { // Nach erfolgreicher Verschiebung timeout setzen
                this.timeoutHandler = setTimeout(
                    ()=>this.translate(0,1),
                    this.timestep);
            }
            return true;
        }
        if (dy==1) { // Verschiebung nach unten hat fehlgeschlagen
            this.checkLines();
            this.newBlock();  // Setzt selbst den Timeout
        }
        return false;
    }


    checkLines() {
        this.toClear=[]
        for (let y=0; y<this.raster.height; y++) {
            // Überprüfe Zeile y
            let full = true;
            for (let x=0; x<this.raster.width; x++) {
                if (this.raster.getValue(x,y)==0) {
                    full = false;
                    break;
                }
            }
            if (full) {
                this.toClear.push(y);
            }
        }
        for (let y of this.toClear) {
            for (let y2=y; y2>=0; y2--) {
                for (let x=0; x<this.raster.width; x++) {
                    if (y2==0) {
                        this.raster.setValue(x,y2,0);
                    } else {
                        this.raster.setValue(x,y2,this.raster.getValue(x,y2-1));
                    }
                }
            }
        }                               //  Anzahl abgebauter Zeilen
        if (this.toClear.length>1) {
            this.multipleLinesCallback(this, this.toClear.length);
        }
        // Lösche volle Zeilen
        // Rest herunter fallen lassen
    }

}