class Raster {
    constructor(w,h, containerId="gridcontainer") {
        this.width = w;
        this.height = h;
        // New array of size x times y
        this.cells = Array(this.width).fill(0).map(e=>Array(this.height).fill(undefined));
        this.clickCallback = undefined;
        
        document.body.style.setProperty("--spalten", this.width);
        document.body.style.setProperty("--zeilen", this.height);
        document.body.style.setProperty("--gridaspect", this.width/this.height)

        this.container = document.getElementById(containerId);

        for (let y=0; y<this.height; y++) {
            this.cells.push([]);
            for (let x=0; x<this.width; x++) {
                let d = document.createElement('div');
                d.classList.add("cell");
                d.setAttribute('spalte', x);
                d.setAttribute('zeile', y);
                d.setAttribute('wert', 0);
                d.classList.add("wert0");
                this.container.appendChild(d);
                this.cells[x][y]=d;
            }
        }
        this.container.addEventListener('click', (ev)=>this.processClick(ev));
    }
    
    processClick(ev) {
        let el = ev.srcElement; // Element, auf das geklickt wurde
        if (el.id==this.container.id) {
            return;
        }
        while (!el.classList.contains('cell')) {
            el = el.parentElement;
            if (el.id==this.container.id) {
                return;
            }
        }
        let x = el.getAttribute('spalte');
        let y = el.getAttribute('zeile');
        if (this.clickCallback) {
            this.clickCallback(x,y);
        }
    }

    isOn(x,y) {
        return (x>=0 && y>=0 && x<this.width && y<this.height);
    }

    setValue(x,y,v) {
        if (!this.isOn(x,y)) {
            throw Error(`No Element (${x},${y}) in Grid with width=${this.width} and height=${this.height}`);
        }
        let d = this.cells[x][y];
        let alt = `wert${d.getAttribute('wert')}`
        let neu = `wert${v}`;
        d.classList.replace(alt, neu);
        d.setAttribute('wert', v);        
    }

    getValue(x,y) {
        if (!this.isOn(x,y)) {
            throw Error(`No Element (${x},${y}) in Grid with width=${this.width} and height=${this.height}`);
        }
        return Number(this.cells[x][y].getAttribute('wert'));
    }

    static addColorRules(colors) {
        let colnum = 0;
        for (let color of colors) {
            document.styleSheets[0].insertRule(`.wert${colnum} { background-color:${color};}`);
            colnum++;
        }
    }
}
