window.addEventListener('load', function() {

    // Code für Ausgabe, stehen lassen
    let ausgabe = document.getElementById('ausgabe');
    function print(...args) {
        for (let a of args) {
            ausgabe.innerText += a;
        }
        ausgabe.innerText+="\n";
    }

    // Code für Eingabe und Programmstart, stehen lassen
    let eingabe = document.getElementById('eingabe');
    eingabe.addEventListener('change', start);
    this.document.getElementById('start').addEventListener('click', start);
    function start() {
        ausgabe.innerText = "";
        main();
    }


    // Aufgaben-Code in der Funktion main
    // Berechnung der Summe von aufeinanderfolgenden natürlichen Zahlen
    function main() {

        // Umwandlung der Eingabe in ein Array von Objects mit den jeweiligen Daten für die Aufgabe
        function eingabeZuArray() {
            // Eingabe als Array von Zeilen (Strings)
            let lines = eingabe.value.split("\n");
            // leere Zeilen und Zeilen, die nur aus Leerschlägen u.ä. bestehen, ignorieren
            lines = lines.filter((l)=> ! (/^\s*$/.test(l)));
            // Anzahl Test-Fälle
            let t = Number(lines[0]);
            // Array für Aufgaben mit Leeren Objekten
            // Erst mit Länge anlegen, mit beliebigem Wert füllen, dann alle Einträge durch ein neues, leeres Objekt ersetzen
            // .fill(new Object()) würde nicht funktionieren, da dann alle Einträge auf dasselbe Objekt zeigen würden.
            let aufgaben = new Array(t).fill(null).map(()=>new Object());
            // Array befüllen
            for (let i=0; i<t; i++) {
                // Zeile nach Leerschlägen trennen und in Zahlen umwandeln
                let zahlen = lines[i+1].split(" ").map((zahl)=>Number(zahl));
                // Object mit den Daten für die Aufgabe in Array speichern
                aufgaben[i].a = zahlen[0];
                aufgaben[i].b = zahlen[1];
            }
            // Alle Aufgabe zurückgeben
            return aufgaben;
        }
        
        // Kern des Programms, löst jeweils eine Aufgabe und gibt die Lösung aus
        function loesung(aufgabe) {
            let summe = 0;
            for (let i=aufgabe.a; i<=aufgabe.b; i++) {
                summe += i;
            }
            return summe;
        }

        // Auslesen aller Testfälle
        let aufgaben = eingabeZuArray();
        // Aufruf der Funktion für jeden Testfall
        for (let a=0; a<aufgaben.length; a++) {
            print(`Case #${a}: ${loesung(aufgaben[a])}`);
        }
        
    }

});