window.addEventListener('load', function() {

    let voki = {'title':'Neues Voki', '1stlanguage':'de', '2ndlanguage':'fr', 'words':[]};
    let filename = "neues_voki.json";
    let liste = document.getElementById('liste');
    let abfragen = document.getElementById('abfragen');
    let wantedword = document.getElementById('wantedword');
    let indexAktuellesWort = 0;

    // Neues Wort anlegen 
    function newWord() {
        let nw = {};
        nw[voki["1stlanguage"]] = "neu";
        nw[voki["2ndlanguage"]] = "neu";
        return nw;
    }

    // Weiteres Wort in der Liste hinzufügen
    function newListRow(word, addToList=true) {
        if (addToList) voki.words.push(word);
        document.getElementById('numwords').innerText = voki['words'].length;
        for (let key of ['1stlanguage', '2ndlanguage']) {
            key = voki[key];
            let d = document.createElement('div');
            d.innerText = word[key];
            // Make editable and store changes
            d.setAttribute("contenteditable", "true");
            d.addEventListener('input', function(w,k) {
                return function() {
                    w[k]=this.innerText;
                };
            }(word,key));

            d.addEventListener('focus', function() {
                // From https://stackoverflow.com/questions/3805852/select-all-text-in-contenteditable-div-when-it-focus-click
                let div = this;
                console.log('focus!')
                setTimeout(function() {
                    var sel, range;
                    if (window.getSelection && document.createRange) {
                        range = document.createRange();
                        range.selectNodeContents(div);
                        sel = window.getSelection();
                        sel.removeAllRanges();
                        sel.addRange(range);
                    } else if (document.body.createTextRange) {
                        range = document.body.createTextRange();
                        range.moveToElementText(div);
                        range.select();
                    }
                }, 1);
            });
            liste.insertBefore(d, liste.lastChild);
        }
    }

    // Liste
    function data2html() {
        document.getElementById('vokiname').innerText = voki['title'];
        document.getElementById('numwords').innerText = voki['words'].length;
        document.getElementById('1stlanguage').innerText = voki['1stlanguage'];
        document.getElementById('2ndlanguage').innerText = voki['2ndlanguage'];
        liste.innerHTML = "";  // Clear the list

        let b = document.createElement('button');
        b.innerText = "neues Wortpaar"
        b.addEventListener('click', function() {
            newListRow(newWord());
        });
        liste.appendChild(b);

        for (let word of voki.words) {
            newListRow(word, false); // Nicht der voki-Liste hinzufügen, nur der HTML-Liste
        }
        liste.style.display="grid";
        abfragen.style.display="none";
    }
    
    // Upload
    this.document.getElementById('upload').addEventListener('change', function(ev) {
        let file = this.files[0];     // this refers to the input element
        filename = file.name;
        let reader = new FileReader();   // Reader to read data
        reader.addEventListener('load', function(ev) {  // What to do, when data is ready
            voki = JSON.parse(ev.target.result);
            data2html();
        });
        reader.readAsText(file);  // read as text (other formats are possible, see https://developer.mozilla.org/en-US/docs/Web/API/FileReader)
    });

    // Download
    let download = document.createElement('a');
    download.style.display = "hidden";
    this.document.body.appendChild(download);
    this.document.querySelectorAll("#menu>button")[1].addEventListener('click', function() {
        let text = JSON.stringify(voki, null, 4);
        let data = new Blob([text], {encoding:"UTF-8",type:"text/plain;charset=utf-8"});
        download.download = filename;           // set Filename
        download.href = URL.createObjectURL(data);    // Prepare data link
        download.click();                             // Click the a tag (to start the download immediately to the Downloads folder)
    });

    function chooseWord() {
        indexAktuellesWort = Math.floor(Math.random()*voki.words.length);
        document.getElementById('givenword').innerText = voki.words[indexAktuellesWort][voki["1stlanguage"]];
        wantedword.value = "";
        wantedword.focus();
    }

    // Training
    this.document.querySelectorAll("#menu>button")[0].addEventListener('click', function() {
        if (abfragen.style.display=="none") {
            liste.style.display="none";
            abfragen.style.display="flex";
            this.innerText = "Liste"
            chooseWord();
        } else {
            this.innerText = "Training"
            liste.style.display="grid";
            abfragen.style.display="none";
        }
    });

    wantedword.addEventListener('change', function() {
        if (wantedword.value == voki.words[indexAktuellesWort][voki["2ndlanguage"]]) {
            chooseWord();
        } else {
            abfragen.style.animationName="wrongword";
            wantedword.focus();
            setTimeout(function(){abfragen.style.animationName=""}, 2000);
        }
    });

    data2html();
});