window.addEventListener('load', function(){
    let divListe = document.getElementById('liste');
    let liste = [];

    function save() {
        localStorage.setItem('todoliste', JSON.stringify(liste));
    }

    function addItem(item) {
        let d = document.createElement('li');
        d.setAttribute('contenteditable', true);
        d.innerText = item['name'];
        d.addEventListener('input', function() {
            item['name']=this.innerText;
            save();
        });
        divListe.appendChild(d);
    }

    function init() {
        let ls = localStorage.getItem('todoliste');
        if (ls) {
            liste = JSON.parse(ls);
        } else {
            liste = [{'name':'JS lernen'}, {'name':'CSS repetieren'}];
            localStorage.setItem('todoliste', JSON.stringify(liste));
        }
        for (let item of liste) {
            addItem(item);
        }
    }

    this.document.getElementById('add').addEventListener('click', function() {
        let item = {'name':'Neu'};
        liste.push(item);
        addItem(item);
    });

    init();

});