window.addEventListener('load', function() {
    let mytext = this.document.getElementById('mytext');

    // Create empty a tag and add it to the page
    let exportElement = document.createElement('a');
    this.document.body.appendChild(exportElement);

    // Upload file to page.
    this.document.getElementById('upload').addEventListener('change', function(ev) {
        let file = this.files[0];     // this refers to the input element

        let reader = new FileReader();   // Reader to read data
        reader.addEventListener('load', function(ev) {  // What to do, when data is ready
            mytext.value = ev.target.result;
        });
        reader.readAsText(file);  // read as text (other formats are possible, see https://developer.mozilla.org/en-US/docs/Web/API/FileReader)
    });



    this.document.getElementById('download').addEventListener('click', function() {
        let text = mytext.value;
        let data = new Blob([text], {encoding:"UTF-8",type:"text/plain;charset=utf-8"});

        exportElement.download = "demotext.txt";           // set Filename
        exportElement.href = URL.createObjectURL(data);    // Prepare data link
        //exportElement.click();                             // Click the a tag (to start the download immediately to the Downloads folder)
        exportElement.innerText = "Download "+exportElement.download;     // This link can be right-clicked to save the file to a location of the users choosing.

    });

});