// Erst mal alles Laden, erst dann an der Webseite
// Dinge ändern (die sonst noch gar nicht existieren würden)
window.addEventListener('load', function() {

    // Raster anlegen
    // Diese Variable ist ab hier auch in Unterfunktionen
    // definiert und verwendbar
    let meinRaster = new Raster(6,6);

    // Nützliche Variablen
    let imgs = {'leer':0, 'kopf':1, 'gerade':2, 'rank':3, 'schwanz':4, 'tot':5};
    let directions = [[1,0], [0,1], [-1,0], [0,-1]];
    // Variablen für das Snake-Spiel, initialisiert in reset
    let currentDirection;
    let newDirection;

    function reset() {
        meinRaster.fill(0);
        currentDirection = 0;
        newDirection = 0;
    }

    function demo() {
        for (let wert=1; wert<5; wert++) {
            for (let r=0; r<4; r++) {
                meinRaster.setValue(r+1,wert,wert,r);
            }
        }
    }

    function startGame() {
        console.log("startGame ist noch nicht implementiert")
    }

    this.window.addEventListener('keydown', function(event) {
        let dirKeys = ["ArrowRight", "ArrowDown", "ArrowLeft", "ArrowUp"];
        for (let d=0; d<4; d++) { // Alle vier Richtungen
            if (event.key==dirKeys[d]) {
                if (currentDirection != (d+2)%4) {  // Wenn nicht entgegengesetzt
                    newDirection = d;
                }
            }
        }
    });

    this.document.getElementById('resetknopf').addEventListener('click', reset);
    this.document.getElementById('demoknopf').addEventListener('click', demo);
    this.document.getElementById('startknopf').addEventListener('click', startGame);

    reset();

});