window.addEventListener('load', function() {

    const ziffernblock = document.getElementById("ziffernblock");
    const buttons = ziffernblock.children;
    let numbers = [];  // Buttons by number
    const tones = [0,2,4,5,7,9,11,12,14,16];  // Dur-Tonleiter
    const pidigits="31415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989";

/* 	 from https://en.wikipedia.org/wiki/Dual-tone_multi-frequency_signaling
1209 Hz	1336 Hz	1477 Hz	1633 Hz
697 Hz	1	2	3	A
770 Hz	4	5	6	B
852 Hz	7	8	9	C
941 Hz	*	0	#	D
*/

    const rowfreq = [697, 770, 852, 941];
    const colfreq = [1209, 1336, 1477, 1633];

    let pilen = 2;
    let pipos = 0;
    let running = 0;

    lang = document.getElementById("lang");
    ziffer = document.getElementById("ziffer");

    // Audio zeugs: https://jsfiddle.net/njb91z84/113/
    // create web audio api context
    let audioCtx = new (window.AudioContext || window.webkitAudioContext)();
    function playNote(frequency, duration, callback=null) {
        // create Oscillator node
        var oscillator = audioCtx.createOscillator();
        
        oscillator.type = 'square';
        oscillator.type = 'sine';
        oscillator.frequency.value = frequency; // value in hertz
        oscillator.connect(audioCtx.destination);
        if (callback != null) {
            oscillator.onended = callback;
        }
        oscillator.start(0);
        oscillator.stop(audioCtx.currentTime + duration);
    }
    
    function playDualTone(nr, duration) {
        let row = 3;
        let col = 1;
        if (nr>0) {
            row = Math.floor((nr-1)/3);
            col = (nr-1) % 3;
        }
        playNote(rowfreq[row],duration);
        playNote(colfreq[col],duration);
    }

    function setLang(l) {
        lang.innerText = l;
        pilen = l;
    }

    function setPiPos(p) {
        if (p>pilen) {
            setLang(p);
        }
        pipos = p;
        ziffer.innerText = pipos;
    }

    function startAnim(el, prg=false) {
        el.classList.remove("lightup");
        el.classList.add("stopanim");
        el.classList.remove("stopanim");
        el.classList.add("lightup");
        //playNote(220*Math.pow(2,tones[Number(el.innerText)]/12.0), 0.15);
        playDualTone(Number(el.innerText), 0.15);
        setTimeout(() => {
            el.classList.remove("lightup");
        }, 300);
        if (prg==false) {
            let nr = Number(el.innerText);
            if (nr == pidigits[pipos]) {
                setPiPos(pipos+1);
            } else {
                setPiPos(0);
                playNote(180,0.5);
                ziffernblock.classList.add("error");
                setTimeout(()=>{
                    ziffernblock.classList.remove("error");
                }, 600);
            }
        }
    }

    function buttonClick() {
        startAnim(this);
    }


    this.window.addEventListener('keypress', (ev) => {
        if (ev.key>='0' && ev.key<='9') {
            nr = Number(ev.key);
            startAnim(numbers[nr]);
        }
    });

    function langChange() {
        let r = lang.innerText.match(/\d+/);
        let l = 0;
        if (r?.length>0) {
            l = Number(r[0]);
        }
        if (l>1000) {
            l = 1000;
        }
        lang.innerText = l;
        pilen = l;

    }

    function showRest() {
        if (pipos<pilen) {
            startAnim(numbers[Number(pidigits[pipos])], true);
            setPiPos(pipos+1);
            if (running==1) {
                setTimeout(showRest, 400);
            }
        }
    }


    function init() {
        const mycolors = ["red", "#555", "#ff0", 
                        "#aaa", "green", "#0ff", 
                        "#f0f", "#840", "blue", 
                        "#eee"];
        for (let i=0;i<10; i++) {
            buttons[i].style = `background-color: ${mycolors[i]};`;
            buttons[i].addEventListener('click',buttonClick);
            let nr = Number(buttons[i].innerText);
            numbers[nr] = buttons[i];
        }
        lang.innerText = pilen;
        ziffer.innerText = pipos;
        lang.addEventListener('input', langChange);
        buttons[12].addEventListener('click', ()=>{
            startAnim(numbers[Number(pidigits[pipos])], true);
        })
        buttons[10].addEventListener('click', ()=>{running=0; setPiPos(0);});
        buttons[11].addEventListener('click', ()=>{setPiPos(0); running=1; showRest()});
    }
    init();
});
