window.addEventListener('load', function() {

    const spieldfeld = document.getElementById('spielfeld');
    const resetknopf = document.getElementById('resetknopf');

    const feldklassen = ["feldleer", "feldeins", "feldzwei"];

    const getWert = function(div) {
        return Number(div.attributes.wert.value);
    }

    const setWert = function(div, wert) {
        div.setAttribute('wert', wert);
        div.className = feldklassen[wert];
    }

    const feldClick = function() {
        let div = this;
        setWert(div, (getWert(div)+1)%3);
    }

    const getDiv = function(spalte, zeile) {
        return spieldfeld.children.item(spalte+7*zeile);
    }

    const makeFeld = function() {
        for (let zeile=0; zeile<6; zeile++) {
            for (let spalte=0; spalte<7; spalte++) {
                let wert = (zeile+spalte) % 3;
                // Unterelement erzeugen
                let div = document.createElement('div');
                // Attribute setzen
                div.setAttribute('spalte', spalte);
                div.setAttribute('zeile', zeile);
                // Klick-Funktion definieren
                div.addEventListener('click', feldClick);
                // Klasse für die Darstellung hinzufügen
                setWert(div,wert);
                // Dem Feld hinzufügen
                spieldfeld.appendChild(div);
            }
        }
    }

    const reset = function() {
        for (let div of spieldfeld.children) {
            setWert(div, 0);
        }
    } 

    const init = function() {
        makeFeld();
        resetknopf.addEventListener('click',reset);
    }

    init();
});