window.addEventListener('load', function() {

    const spieldfeld = document.getElementById('spielfeld');
    const resetknopf = document.getElementById('resetknopf');

    const feldklassen = ["feldleer", "feldeins", "feldzwei"];

    const feldClick = function() {
        let div = this;
        let spalte = Number(div.attributes.spalte.value);
        let zeile = Number(div.attributes.zeile.value);
        let wert = Number(div.attributes.wert.value);
        console.log(`Click auf Feld mit Wert ${wert} in Spalte ${spalte} und Zeile ${zeile}.`);
    }

    const makeFeld = function() {        
        for (let zeile=0; zeile<6; zeile++) {
            for (let spalte=0; spalte<7; spalte++) {
                let wert = (zeile+spalte) % 3;
                // Unterelement erzeugen
                let div = document.createElement('div');
                // Attribute setzen
                div.setAttribute('spalte', spalte);
                div.setAttribute('zeile', zeile);
                div.setAttribute('wert', wert);
                // Klick-Funktion definieren
                div.addEventListener('click', feldClick);
                // Klasse für die Darstellung hinzufügen
                div.className = feldklassen[wert];
                // Dem Feld hinzufügen
                spieldfeld.appendChild(div);
            }
        }
    }

    const init = function() {
        makeFeld();
    }

    init();
});