window.addEventListener('load', function() {

    const spieldfeld = document.getElementById('spielfeld');
    const resetknopf = document.getElementById('resetknopf');

    const feldklassen = ["feldleer", "feldeins", "feldzwei"];

    let spieler = 1;   // Wer ist dran?

    const getWert = function(div) {
        return Number(div.attributes.wert.value);
    }

    const setWert = function(div, wert) {
        div.setAttribute('wert', wert);
        div.className = feldklassen[wert];
    }

    const getDiv = function(spalte, zeile) {
        return spieldfeld.children.item(spalte+7*zeile);
    }

    const feldClick = function() {
        let div = this;
        let spalte = Number(div.attributes.spalte.value);

        let zeile = 5; // zuunterst starten
        while (zeile>=0 && getWert(getDiv(spalte, zeile))!=0) {  // Wiederholen, so lange das Feld besetzt ist und die zeile noch nicht negativ ist
            zeile--;
        }
        if (zeile==-1) { // negative zeile? Also alles voll.
            return;  // Funktion sofort abbrechen
        }

        // Wert auf freien Platz setzen
        setWert(getDiv(spalte, zeile), spieler);

        // Der andere Spieler ist jetzt an der Reihe
        spieler = 3-spieler;
    }


    const makeFeld = function() {
        for (let zeile=0; zeile<6; zeile++) {
            for (let spalte=0; spalte<7; spalte++) {
                // Unterelement erzeugen
                let div = document.createElement('div');
                // Attribute setzen
                div.setAttribute('spalte', spalte);
                div.setAttribute('zeile', zeile);
                // Klick-Funktion definieren
                div.addEventListener('click', feldClick);
                // Klasse für die Darstellung hinzufügen
                setWert(div, 0);
                // Dem Feld hinzufügen
                spieldfeld.appendChild(div);
            }
        }
    }

    const reset = function() {
        for (let div of spieldfeld.children) {
            setWert(div, 0);
        }
        spieler = 1;        // Wer ist dran?
    } 

    const init = function() {
        makeFeld();
        resetknopf.addEventListener('click',reset);
        reset();
    }

    init();
});