window.addEventListener('load', function() {

    const spieldfeld = document.getElementById('spielfeld');
    const resetknopf = document.getElementById('resetknopf');

    const feldklassen = ["feldleer", "feldeins", "feldzwei"];

    let spieler = 1;

    const getWert = function(div) {
        return Number(div.attributes.wert.value);
    }

    const setWert = function(div, wert) {
        div.setAttribute('wert', wert);
        div.className = feldklassen[wert];
    }

    const feldClick = function() {
        if (spieler!=1) return;  // Don't let the computer play
        let x = Number(this.getAttribute('spalte'));
        let y = -1;
        while (y<5 && getValueAt(x,y+1)==0) { y++ }
        
        if (y==-1) return; // Spalte schon voll
        //console.log(`Place at ${x},${y}`);
        let div = getDiv(x,y);
        setWert(div, spieler);
        if (pruefen(x,y)) {
            setTimeout(function() {
                alert(`Spieler ${spieler} gewinnt!`);
                reset();
                spieler = 1;
            }, 100);
        } else {
            spieler = 3-spieler;
            setTimeout(function() {
                computerGegener.init();
                [x,y,score] = computerGegener.bestMove(spieler, 5, true);
                let div = getDiv(x,y);
                setWert(div, spieler);
                if (pruefen(x,y)) {
                    setTimeout(function() {
                        alert(`Spieler ${spieler} gewinnt!`);
                        reset();
                        spieler = 1;
                    }, 100);
                } else {
                    spieler = 3-spieler;
                }
            },100);
        }

    }

    const getDiv = function(spalte, zeile) {
        return spieldfeld.children.item(spalte+7*zeile);
    }

    const makeFeld = function() {
        for (let zeile=0; zeile<6; zeile++) {
            for (let spalte=0; spalte<7; spalte++) {
                // Unterelement erzeugen
                let div = document.createElement('div');
                // Attribute setzen
                div.setAttribute('spalte', spalte);
                div.setAttribute('zeile', zeile);
                // Klick-Funktion definieren
                div.addEventListener('click', feldClick);
                // Klasse für die Darstellung hinzufügen
                setWert(div,0);
                // Dem Feld hinzufügen
                spieldfeld.appendChild(div);
            }
        }
    }

    // Zugriff auf Feld etwas vereinfachen:
    function getValueAt(x,y) {
        //console.log(`getValueAt(${x},${y})`);
        if (x<0 || y<0 || x>=7 || y>=6) return 0;
        return Number(getDiv(x,y).getAttribute('wert'));
    }
    
    // Gibt die Anzahl gleicher Felder an, wenn man bei (startx, starty) startet und in Richtung (dx,dy) weiter geht.
    // Ist das Startfeld schon 0, wird sofort 0 zurückgegeben
    function count(startx, starty, dx, dy) {
        let wert = getValueAt(startx,starty);             // Wert auf Startfeld
        if (wert==0) return 0;                            // Keine Nuller zählen
        let anzahl = 0;
        while (wert==getValueAt(startx,starty)) {         // Immer noch das Gleiche?
            anzahl++;
            startx+=dx;                                   // Vorwärts
            starty+=dy;
        }
        return anzahl;
    }
    
    // Liefert true, wenn die Position (x, y) Teil eines Vierers ist
    function pruefen(x, y) {
        let dirs = [[1,0], [1,1], [0,1], [-1,1]]; // Trigonometrisch, 45 Grad Schritte.
        for (let d of dirs) {
            let anzahl = count(x, y, d[0], d[1]) + 
                        count(x, y, -d[0], -d[1]) - 1;
            if (anzahl>=4) {
                return true;
            }
        }
        return false;
    }

    const reset = function() {
        for (let div of spieldfeld.children) {
            setWert(div, 0);
        }
    } 

    const init = function() {
        makeFeld();
        resetknopf.addEventListener('click',reset);
    }

    var computerGegener = {
        feld : undefined,  // 2-dimensional array, feld[x][y] contains 0,1,2
        zugy : undefined,  // 1-dimensional array, zugy[x] contains available y-coordinate for next turn (-1 means its full)

        on : function(x,y) {
            return !(x<0 || y<0 || x>=7 || y>=6);
        },

        value : function(x,y) {
            if (!this.on(x,y)) return 0;
            return this.feld[x][y];
        },

        count: function(x,y,dx,dy) { // Zählt gleicher Farbe von x,y in Richtung dx,dy
            let w = this.value(x,y);
            if (w==0) return 0;
            let c = 0;
            while (this.value(x,y)==w) {
                x+=dx;
                y+=dy;
                c++;
            }
            return c;
        },

        check: function(x,y) {  // Sucht Vierer (bzw. längste Kette von x,y aus)
            let dirs = [[1,0], [1,1], [0,1], [-1,1]]; // Trigonometrisch, 90 Grad Schritte.
            let best = 0;
            let total = 0;
            for (let d of dirs) {
                let anzahl = this.count(x, y, d[0], d[1]) + 
                        this.count(x, y, -d[0], -d[1]) - 1;
                if (anzahl>=best) {
                    best = anzahl;
                }
                total += anzahl;
            }
            return [best, total];
        },

        potential : function(x,y,dx,dy) { // Zählt Steine der Farbe wie x,y und leere Positionen
            let w = this.value(x,y);
            let zeros = 0;
            let pieces = 0;
            while (this.on(x,y)) {
                let v = this.value(x,y);
                if (v==3-w) break;
                if (v==w) {
                    pieces++;
                } else {
                    zeros++;
                }
                x+=dx;
                y+=dy;
            }
            return [pieces,zeros];
        },

        positionvalue : function(x,y) {  // Gibt ein Score, wie wichtig ein Stein ist (i.e. in wie vielen Vierern dieser sein könnte)
            let dirs = [[1,0], [1,1], [0,1], [-1,1]]; // Trigonometrisch, 45 Grad Schritte.
            let score = 0;
            for (let d of dirs) {
                let [p1,z1] = this.potential(x, y, d[0], d[1]);
                let [p2,z2] = this.potential(x, y, -d[0], -d[1]);
                let p = p1+p2-1;
                let z = z1+z2;
                if (p+z>=4) {
                    score += 7*p*p+z1+z2;
                }
            }
            return score;
        },

        bewerten : function(lastx, lasty) { // Bewertungsfunktion (zur Zeit sehr aufwendig)
            let [best, total] = this.check(lastx,lasty);
            if (best>=4) return 9999;  // Winner!
            //return total+Math.pow(3-Math.abs(3-lastx),3);  // ziemlich einfältige Bewertung
            let p = this.value(lastx, lasty); // Spieler
            let score = 0;
            for (let x=0; x<7; x++) { // Alle Felder durchgehen, auf dem dieser Spieler Steine hat
                for (let y=5; y>=0; y--) {
                    let v = this.feld[x][y];
                    if (v==0) { 
                        break;
                    }
                    let s = this.positionvalue(x,y);
                    //console.log(`positionvalue at ${x},${y} is s=${s}`)
                    if (v==p) {
                        score += s;
                    } else {
                        score -= s;
                    }
                }
            }
            return score;
        },

        // Daten aus Spielfeld übernehmen und freie y-Positionen berechnen
        init: function() {
            this.feld = Array(7).fill(0).map((row,x)=>Array(6).fill(0).map((col,y)=>getValueAt(x,y)));
            this.zugy = Array(7).fill(5);
            for (let x=0; x<7; x++) {
                while (this.value(x,this.zugy[x])!=0) { this.zugy[x]--}
            }
        },

        // let the magic happen...
        // returns [bestx, besty, score]
        bestMove: function(player, depth=1, first=false) {
            let best=[-1,-1,-10000];   // Default move (worse than loosing)
            for (let x=0; x<7; x++) {  // Check all possible moves                
                if (this.zugy[x]>=0) {  // only if column has space left
                    let y = this.zugy[x];
                    this.feld[x][y] = player;  // make move
                    this.zugy[x]--;
                    let bewertung = this.bewerten(x,y);   // get score to find a certain win
                    if (bewertung>=9999) {  // winning move? So that's it, look no further.
                        this.feld[x][y] = 0;  // Undo move
                        this.zugy[x]++;
                        return [x,y,bewertung];
                    }
                    if (depth>0) {  // Can we look further
                        bewertung = -this.bestMove(3-player,depth-1)[2]  // 
                    }
                    if (bewertung>best[2]) {  // Did we find something better?
                        best = [x,y,bewertung];   // Remeber that!
                    }
                    if (first) {
                        console.log(`move at ${x}, ${y} has score ${bewertung}`)
                    }
                    this.feld[x][y] = 0;  // Undo move
                    this.zugy[x]++;
                }
            }
            return best;  // Return best move found
        }
    }


    init();
});