export class Grid {

    // Benötigte Variablen definieren und init-Funktion
    // wird bei der Instanzierung mit z.B. 'grid = new Grid(7,7)' aufgerufen und
    // gibt eine Referenz auf die Instanz zurück 
    // (die im Beispiel in der Variablen grid gespeichert wird).
    constructor(r,c, feldid="feld", onclick=undefined) {
        this.rows = r;
        this.cols = c;
        this.feld = document.getElementById(feldid);
        this.elements = [];
        this.colors = ["black", "white", "yellow", "lightgray", "cyan", "blue", "magenta"];
        this.classes = [];

        // CSS stuff
        this.feld.style.display = "grid";
        const separator = "0.1fr";
        let template = separator;
        let ratio = this.cols/this.rows;
        this.feld.style.width = `min(96vw, ${96*ratio}vh)`;
        this.feld.style.aspectRatio = this.cols/this.rows;
        //this.feld.style.height = `${96*mulh}vh`;
        for (let i=0; i<this.cols/2-1; i++) {
            template += " 1fr "+separator;
        }
        feld.style.gridTemplateColumns = template;
        template = separator;
        for (let i=0; i<this.rows/2-1; i++) {
            template += " 1fr "+separator;
        }
        feld.style.gridTemplateRows = template;

        this.colors.forEach((color,i) => {
            let c = `feld${color}`
            this.classes.push(c);
            document.styleSheets[0].insertRule(`.${c} { background-color:${color};}`)
        })

        // generate divs
        for (r=0; r<this.rows; r++) {
            this.elements[r] = [];
            for (c=0; c<this.cols; c++) {
                let div = document.createElement('div');
                div.setAttribute('spalte', c);
                div.setAttribute('zeile', r);
                div.setAttribute('wert', 0);
                // div.classList.add("basic")
                this.feld.appendChild(div);
                this.elements[r][c] = div;
                this.set(r,c,3)
                if (onclick) {
                    div.addEventListener('click',onclick);
                }
            }
        }
    }

    // Methode (d.h. Funktion dieser Klasse)
    // Zugriff auf Instanzvariablen mit this.variablenname
    set(row, col, val) {
        val = Number(val);
        if (!this.on(row, col)) return; // Ausserhalb vom Feld
        let el = this.elements[row][col]
        let old = el.wert
        if (old==val) return;  // Kein neuer Wert
        if (old>=0 && old<this.classes.length) {
            el.classList.remove(this.classes[old])
        }
        if (val>=0 && val<this.classes.length) {
            el.wert = val
            el.classList.add(this.classes[val])
        }
    }

    on(row, col) {
        return !(row<0 || col<0 || row>=this.rows || col>=this.cols)
    }

    get(row, col) {
        if (!this.on(row, col)) return undefined
        return Number(this.elements[row][col].wert);
    }

    toCSV() {
        let csv = "";
        for (let r=0; r<this.rows; r++) {
            for (let c=0; c<this.cols; c++) {
                csv += this.get(r,c)+";";
            }
            csv += "\n";
        }
        let data = new Blob([csv], {encoding:"UTF-8",type:"text/csv;charset=utf-8"});
        let a = document.getElementById('exportieren');
        a.download = "labyrinth.csv";
        a.href = URL.createObjectURL(data);
        a.click();
    }

}
