import { Grid } from "./grid.js";
import { Labyrinth as Laby } from "./labyrinth.js";  // Namen können geändert werden, um Kollisionen zu vermeiden.

window.addEventListener('load', function() {
    let grid = new Grid(43,31, 'feld'); 
    let laby = new Laby(grid);


    let controls = document.getElementById('controls');
    let callbacks = [
        ()=>{if (!laby.running) {laby.animate();}},
        ()=>{if (!laby.running) {laby.generate();}},
        ()=>{grid.toCSV()}
    ]
    for (let i=0; i<callbacks.length; i++) {
        controls.children.item(i).addEventListener('click', callbacks[i]);
    }

});

